/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.UnimplementedException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.ReflectionPackableMethod;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcStreamServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcStreamingDecoder;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUnaryServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListener;

public class GrpcHttp2ServerTransportListener
extends GenericHttp2ServerTransportListener
implements Http2TransportListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(GrpcHttp2ServerTransportListener.class);

    public GrpcHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(h2StreamChannel, url, frameworkModel);
    }

    @Override
    protected void onBeforeMetadata(Http2Header metadata) {
    }

    @Override
    protected Executor initializeExecutor(URL url, Http2Header metadata) {
        return this.getExecutor(url, metadata);
    }

    @Override
    protected void onPrepareMetadata(Http2Header metadata) {
        this.doRoute(metadata);
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        this.processGrpcHeaders(metadata);
        super.onMetadataCompletion(metadata);
    }

    private void processGrpcHeaders(Http2Header metadata) {
        String messageEncoding = metadata.header(GrpcHeaderNames.GRPC_ENCODING.getName());
        if (messageEncoding != null && !"identity".equals(messageEncoding)) {
            DeCompressor compressor = DeCompressor.getCompressor(this.getFrameworkModel(), messageEncoding);
            if (compressor == null) {
                throw new UnimplementedException(GrpcHeaderNames.GRPC_ENCODING.getName() + " '" + messageEncoding + "'");
            }
            ((GrpcStreamingDecoder)this.getStreamingDecoder()).setDeCompressor(compressor);
        }
    }

    @Override
    protected StreamingDecoder newStreamingDecoder() {
        return new GrpcStreamingDecoder();
    }

    @Override
    protected Http2ServerChannelObserver newResponseObserver(H2StreamChannel h2StreamChannel) {
        return new GrpcUnaryServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    @Override
    protected Http2ServerChannelObserver newStreamResponseObserver(H2StreamChannel h2StreamChannel) {
        return new GrpcStreamServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    @Override
    protected Http2ServerChannelObserver prepareResponseObserver(Http2ServerChannelObserver responseObserver) {
        responseObserver.addTrailersCustomizer(this.getExceptionCustomizerWrapper()::customizeGrpcStatus);
        return super.prepareResponseObserver(responseObserver);
    }

    @Override
    protected HttpMessageListener buildHttpMessageListener() {
        return this.getContext().isHasStub() ? super.buildHttpMessageListener() : new LazyFindMethodListener();
    }

    @Override
    protected void prepareUnaryServerCall() {
        if (this.needWrap()) {
            this.getExceptionCustomizerWrapper().setNeedWrap(true);
        }
    }

    private boolean needWrap() {
        RpcInvocationBuildContext context = this.getContext();
        if (context.isHasStub()) {
            return false;
        }
        MethodMetadata methodMetadata = context.getMethodMetadata();
        return ReflectionPackableMethod.needWrap(context.getMethodDescriptor(), methodMetadata.getActualRequestTypes(), methodMetadata.getActualResponseType());
    }

    @Override
    protected RpcInvocation onBuildRpcInvocationCompletion(RpcInvocation invocation) {
        String timeoutString = ((Http2Header)this.getHttpMetadata()).header(GrpcHeaderNames.GRPC_TIMEOUT.getName());
        try {
            if (timeoutString != null) {
                Long timeout = GrpcUtils.parseTimeoutToMills(timeoutString);
                invocation.put("timeout", timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-9", "", "", String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeoutString, this.getContext().getServiceDescriptor().getInterfaceName(), this.getContext().getMethodName()));
        }
        return invocation;
    }

    @Override
    protected Function<Throwable, Object> getExceptionCustomizer() {
        return this.getExceptionCustomizerWrapper()::customizeGrpc;
    }

    @Override
    protected void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        ((GrpcCompositeCodec)this.getContext().getHttpMessageDecoder()).loadPackableMethod(methodDescriptor);
        super.setMethodDescriptor(methodDescriptor);
    }

    private class LazyFindMethodListener
    implements HttpMessageListener {
        private final StreamingDecoder streamingDecoder = new GrpcStreamingDecoder();

        private LazyFindMethodListener() {
            this.streamingDecoder.setFragmentListener(new DetermineMethodDescriptorListener());
            this.streamingDecoder.request(Integer.MAX_VALUE);
        }

        @Override
        public void onMessage(InputStream inputStream) {
            this.streamingDecoder.decode(inputStream);
        }
    }

    private class DetermineMethodDescriptorListener
    implements StreamingDecoder.FragmentListener {
        private DetermineMethodDescriptorListener() {
        }

        @Override
        public void onClose() {
            GrpcHttp2ServerTransportListener.this.getStreamingDecoder().close();
        }

        @Override
        public void onFragmentMessage(InputStream rawMessage) {
            try {
                RpcInvocationBuildContext context = GrpcHttp2ServerTransportListener.this.getContext();
                if (context.getMethodDescriptor() == null) {
                    MethodDescriptor methodDescriptor = DescriptorUtils.findTripleMethodDescriptor(context.getServiceDescriptor(), context.getMethodName(), rawMessage);
                    GrpcHttp2ServerTransportListener.this.setMethodDescriptor(methodDescriptor);
                    GrpcHttp2ServerTransportListener.this.setHttpMessageListener(GrpcHttp2ServerTransportListener.super.buildHttpMessageListener());
                }
                ((GrpcStreamingDecoder)GrpcHttp2ServerTransportListener.this.getStreamingDecoder()).invokeListener(rawMessage);
            }
            catch (IOException e) {
                throw new DecodeException(e);
            }
        }
    }
}

