/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;

public final class HttpMessageEncoderWrapper
implements HttpMessageEncoder {
    private final Charset charset;
    private final MediaType mediaType;
    private final HttpMessageEncoder httpMessageEncoder;

    public HttpMessageEncoderWrapper(Charset charset, MediaType mediaType, HttpMessageEncoder httpMessageEncoder) {
        this.charset = charset;
        this.mediaType = mediaType;
        this.httpMessageEncoder = httpMessageEncoder;
    }

    public HttpMessageEncoderWrapper(Charset charset, HttpMessageEncoder httpMessageEncoder) {
        this.charset = charset;
        this.mediaType = httpMessageEncoder.mediaType();
        this.httpMessageEncoder = httpMessageEncoder;
    }

    public Charset charset() {
        return this.charset;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public boolean supports(String mediaType) {
        return this.httpMessageEncoder.supports(mediaType);
    }

    @Override
    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        this.httpMessageEncoder.encode(outputStream, data, this.charset);
    }

    @Override
    public void encode(OutputStream outputStream, Object[] data, Charset charset) throws EncodeException {
        this.httpMessageEncoder.encode(outputStream, data, this.charset);
    }

    @Override
    public void encode(OutputStream outputStream, Object data) throws EncodeException {
        this.httpMessageEncoder.encode(outputStream, data, this.charset);
    }

    @Override
    public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
        this.httpMessageEncoder.encode(outputStream, data, this.charset);
    }

    @Override
    public String contentType() {
        return this.mediaType.getName() + ";charset=" + this.charset.name();
    }
}

