/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;

@Activate(group={"provider"}, order=-29000)
public class HttpContextFilter
implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invocation.get("tri.handler.type") == null) {
            return invoker.invoke(invocation);
        }
        HttpRequest request = (HttpRequest)invocation.get("tri.http.request");
        HttpResponse response = (HttpResponse)invocation.get("tri.http.response");
        RpcServiceContext context = RpcContext.getServiceContext();
        context.setRemoteAddress(request.remoteHost(), request.remotePort());
        if (context.getLocalAddress() == null) {
            context.setLocalAddress(request.localHost(), request.localPort());
        }
        context.setRequest(request);
        context.setResponse(response);
        return invoker.invoke(invocation);
    }
}

