/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"}, order=10)
public class HttpContextCallbackFilter
implements Filter,
BaseFilter.Listener {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        HttpResult<Object> result;
        Object handlerType = invocation.get("tri.handler.type");
        if (handlerType == null) {
            return;
        }
        Throwable exception = appResponse.getException();
        if (exception instanceof HttpResultPayloadException) {
            HttpResult<Throwable> value = "grpc".equals(handlerType) ? HttpResult.of(exception) : ((HttpResultPayloadException)exception).getResult();
            appResponse.setValue(value);
            appResponse.setException(null);
            return;
        }
        HttpResponse response = (HttpResponse)invocation.get("tri.http.response");
        if (response.isEmpty()) {
            return;
        }
        if (!response.isCommitted()) {
            if (response.isContentEmpty()) {
                response.setBody(appResponse.hasException() ? appResponse.getException() : appResponse.getValue());
            }
            response.commit();
        }
        if ((result = response.toHttpResult()).getBody() instanceof Throwable) {
            appResponse.setException((Throwable)result.getBody());
        } else {
            appResponse.setValue(result);
            appResponse.setException(null);
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

