/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.dubbo.rpc.protocol.tri.command.StreamQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleStreamChannelFuture;

public class TextDataQueueCommand
extends StreamQueueCommand {
    private final String data;
    private final boolean endStream;

    private TextDataQueueCommand(TripleStreamChannelFuture streamChannelFuture, String text, boolean endStream) {
        super(streamChannelFuture);
        this.data = text;
        this.endStream = endStream;
    }

    public static TextDataQueueCommand createCommand(TripleStreamChannelFuture streamChannelFuture, String data, boolean endStream) {
        return new TextDataQueueCommand(streamChannelFuture, data, endStream);
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        ByteBuf buf = ByteBufUtil.writeUtf8(ctx.alloc(), (CharSequence)this.data);
        ctx.write(new DefaultHttp2DataFrame(buf, this.endStream), promise);
    }
}

