/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.function.Consumer;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController;

public class TripleHttp2FrameCodecBuilder
extends Http2FrameCodecBuilder {
    TripleHttp2FrameCodecBuilder(Http2Connection connection) {
        this.connection(connection);
    }

    public static TripleHttp2FrameCodecBuilder fromConnection(Http2Connection connection) {
        return new TripleHttp2FrameCodecBuilder(connection);
    }

    public static TripleHttp2FrameCodecBuilder forClient() {
        return TripleHttp2FrameCodecBuilder.forClient(100);
    }

    public static TripleHttp2FrameCodecBuilder forClient(int maxReservedStreams) {
        return TripleHttp2FrameCodecBuilder.fromConnection(new DefaultHttp2Connection(false, maxReservedStreams));
    }

    public static TripleHttp2FrameCodecBuilder forServer() {
        return TripleHttp2FrameCodecBuilder.forServer(100);
    }

    public static TripleHttp2FrameCodecBuilder forServer(int maxReservedStreams) {
        return TripleHttp2FrameCodecBuilder.fromConnection(new DefaultHttp2Connection(true, maxReservedStreams));
    }

    public TripleHttp2FrameCodecBuilder customizeConnection(Consumer<Http2Connection> connectionCustomizer) {
        Http2Connection connection = this.connection();
        Assert.notNull((Object)connection, "connection cannot be null.");
        connectionCustomizer.accept(connection);
        return this;
    }

    public TripleHttp2FrameCodecBuilder remoteFlowController(Http2RemoteFlowController remoteFlowController) {
        return this.customizeConnection(connection -> connection.remote().flowController(remoteFlowController));
    }

    public TripleHttp2FrameCodecBuilder localFlowController(Http2LocalFlowController localFlowController) {
        return this.customizeConnection(connection -> connection.local().flowController(localFlowController));
    }
}

