/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.netty.shaded.io.netty.util.AsciiString;

public enum TripleHeaderEnum {
    HTTP_STATUS_KEY("http-status"),
    STATUS_KEY("grpc-status"),
    MESSAGE_KEY("grpc-message"),
    STATUS_DETAIL_KEY("grpc-status-details-bin"),
    TIMEOUT("grpc-timeout"),
    GRPC_ENCODING("grpc-encoding"),
    GRPC_ACCEPT_ENCODING("grpc-accept-encoding"),
    CONSUMER_APP_NAME_KEY("tri-consumer-appname"),
    SERVICE_VERSION("tri-service-version"),
    SERVICE_GROUP("tri-service-group"),
    SERVICE_TIMEOUT("tri-service-timeout"),
    TRI_HEADER_CONVERT("tri-header-convert"),
    TRI_EXCEPTION_CODE("tri-exception-code");

    static final Map<String, TripleHeaderEnum> enumMap;
    static final Set<String> excludeAttachmentsSet;
    private final String name;
    private final CharSequence key;

    private TripleHeaderEnum(String name) {
        this.name = name;
        this.key = AsciiString.cached(name);
    }

    public static boolean containsExcludeAttachments(String key) {
        return excludeAttachmentsSet.contains(key) || enumMap.containsKey(key);
    }

    public String getName() {
        return this.name;
    }

    public CharSequence getKey() {
        return this.key;
    }

    static {
        enumMap = new HashMap<String, TripleHeaderEnum>();
        excludeAttachmentsSet = new HashSet<String>();
        for (TripleHeaderEnum tripleHeaderEnum : TripleHeaderEnum.values()) {
            enumMap.put(tripleHeaderEnum.getName(), tripleHeaderEnum);
        }
        for (Enum enum_ : Http2Headers.PseudoHeaderName.values()) {
            excludeAttachmentsSet.add(((Http2Headers.PseudoHeaderName)enum_).value().toString());
        }
        String[] internalHttpHeaders = new String[]{"group", "interface", "path", "remote.application", "application", "serialization", "rest-service-version", "rest-service-group"};
        Collections.addAll(excludeAttachmentsSet, internalHttpHeaders);
    }
}

