/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.Map;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.netty.shaded.io.netty.util.AsciiString;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.protocol.tri.RequestPath;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class RequestMetadata {
    public AsciiString scheme;
    public String application;
    public String service;
    public String version;
    public String group;
    public String address;
    public String acceptEncoding;
    public String timeout;
    public Compressor compressor;
    public CancellationContext cancellationContext;
    public MethodDescriptor method;
    public PackableMethod packableMethod;
    public Map<String, Object> attachments;
    public boolean convertNoLowerHeader;
    public boolean ignoreDefaultVersion;

    public DefaultHttp2Headers toHeaders() {
        DefaultHttp2Headers header = new DefaultHttp2Headers(false);
        ((Http2Headers)header.scheme(this.scheme).authority(this.address).method(HttpMethod.POST.asciiName()).path(RequestPath.toFullPath(this.service, this.method.getMethodName())).set(HttpHeaderNames.CONTENT_TYPE.getKey(), MediaType.APPLICATION_GRPC_PROTO.getName())).set(HttpHeaderNames.TE.getKey(), HttpHeaderValues.TRAILERS);
        this.setIfNotNull(header, TripleHeaderEnum.TIMEOUT.getKey(), this.timeout);
        if (!this.ignoreDefaultVersion || !"1.0.0".equals(this.version)) {
            this.setIfNotNull(header, TripleHeaderEnum.SERVICE_VERSION.getKey(), this.version);
        }
        this.setIfNotNull(header, TripleHeaderEnum.SERVICE_GROUP.getKey(), this.group);
        this.setIfNotNull(header, TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getKey(), this.application);
        this.setIfNotNull(header, TripleHeaderEnum.GRPC_ACCEPT_ENCODING.getKey(), this.acceptEncoding);
        if (!"identity".equals(this.compressor.getMessageEncoding())) {
            this.setIfNotNull(header, TripleHeaderEnum.GRPC_ENCODING.getKey(), this.compressor.getMessageEncoding());
        }
        StreamUtils.putHeaders(header, this.attachments, this.convertNoLowerHeader);
        return header;
    }

    private void setIfNotNull(DefaultHttp2Headers headers, CharSequence key, CharSequence value) {
        if (value == null) {
            return;
        }
        headers.set(key, value);
    }
}

