/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.utils.ProtobufUtils;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.Pack;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.model.UnPack;
import org.apache.dubbo.rpc.model.WrapperUnPack;
import org.apache.dubbo.rpc.protocol.tri.PbArrayPacker;
import org.apache.dubbo.rpc.protocol.tri.PbUnpack;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWrapper;

public class ReflectionPackableMethod
implements PackableMethod {
    private static final String GRPC_ASYNC_RETURN_CLASS = "com.google.common.util.concurrent.ListenableFuture";
    private static final String TRI_ASYNC_RETURN_CLASS = "java.util.concurrent.CompletableFuture";
    private static final String REACTOR_RETURN_CLASS = "reactor.core.publisher.Mono";
    private static final String RX_RETURN_CLASS = "io.reactivex.Single";
    private static final String GRPC_STREAM_CLASS = "io.grpc.stub.StreamObserver";
    private static final Pack PB_PACK = o -> ((Message)o).toByteArray();
    private final Pack requestPack;
    private final Pack responsePack;
    private final UnPack requestUnpack;
    private final UnPack responseUnpack;
    private final boolean needWrapper;
    private final Collection<String> allSerialize;

    @Override
    public boolean needWrapper() {
        return this.needWrapper;
    }

    public ReflectionPackableMethod(MethodDescriptor method, URL url, String serializeName, Collection<String> allSerialize) {
        Class actualResponseType;
        Class[] actualRequestTypes;
        switch (method.getRpcType()) {
            case CLIENT_STREAM: 
            case BI_STREAM: 
            case SERVER_STREAM: {
                actualRequestTypes = method.getActualRequestTypes();
                actualResponseType = method.getActualResponseType();
                break;
            }
            case UNARY: {
                actualRequestTypes = method.getParameterClasses();
                actualResponseType = (Class)method.getReturnTypes()[0];
                break;
            }
            default: {
                throw new IllegalStateException("Can not reach here");
            }
        }
        boolean singleArgument = method.getRpcType() != MethodDescriptor.RpcType.UNARY;
        this.needWrapper = ReflectionPackableMethod.needWrap(method, actualRequestTypes, actualResponseType);
        if (!this.needWrapper) {
            this.requestPack = new PbArrayPacker(singleArgument);
            this.responsePack = PB_PACK;
            this.requestUnpack = new PbUnpack(actualRequestTypes[0]);
            this.responseUnpack = new PbUnpack(actualResponseType);
        } else {
            MultipleSerialization serialization = url.getOrDefaultFrameworkModel().getExtensionLoader(MultipleSerialization.class).getExtension(url.getParameter("serialize.multiple", "default"));
            this.requestPack = new WrapRequestPack(serialization, url, serializeName, actualRequestTypes, singleArgument);
            this.responseUnpack = new WrapResponseUnpack(serialization, url, allSerialize, actualResponseType);
            this.responsePack = new WrapResponsePack(serialization, url, serializeName, actualResponseType);
            this.requestUnpack = new WrapRequestUnpack(serialization, url, allSerialize, actualRequestTypes);
        }
        this.allSerialize = allSerialize;
    }

    public static ReflectionPackableMethod init(MethodDescriptor methodDescriptor, URL url) {
        String serializeName = UrlUtils.serializationOrDefault(url);
        Collection<String> allSerialize = UrlUtils.allSerializations(url);
        return new ReflectionPackableMethod(methodDescriptor, url, serializeName, allSerialize);
    }

    public static boolean isStreamType(Class<?> type) {
        return StreamObserver.class.isAssignableFrom(type) || GRPC_STREAM_CLASS.equalsIgnoreCase(type.getName());
    }

    public static boolean needWrap(MethodDescriptor methodDescriptor, Class<?>[] parameterClasses, Class<?> returnClass) {
        String methodName = methodDescriptor.getMethodName();
        if ("$invoke".equals(methodName) || "$invokeAsync".equals(methodName)) {
            return true;
        }
        if ("$echo".equals(methodName)) {
            return true;
        }
        boolean returnClassProtobuf = ProtobufUtils.isProtobufClass(returnClass);
        if (parameterClasses.length == 0) {
            return !returnClassProtobuf;
        }
        int protobufParameterCount = 0;
        int javaParameterCount = 0;
        int streamParameterCount = 0;
        boolean secondParameterStream = false;
        for (int i = 0; i < parameterClasses.length; ++i) {
            Class<?> parameterClass = parameterClasses[i];
            if (ProtobufUtils.isProtobufClass(parameterClass)) {
                ++protobufParameterCount;
                continue;
            }
            if (ReflectionPackableMethod.isStreamType(parameterClass)) {
                if (i == 1) {
                    secondParameterStream = true;
                }
                ++streamParameterCount;
                continue;
            }
            ++javaParameterCount;
        }
        if (streamParameterCount > 1) {
            throw new IllegalStateException("method params error: more than one Stream params. method=" + methodName);
        }
        if (protobufParameterCount >= 2) {
            throw new IllegalStateException("method params error: more than one protobuf params. method=" + methodName);
        }
        if (streamParameterCount == 1) {
            if (javaParameterCount + protobufParameterCount > 1) {
                throw new IllegalStateException("method params error: server stream does not support more than one normal param. method=" + methodName);
            }
            if (!secondParameterStream) {
                throw new IllegalStateException("method params error: server stream's second param must be StreamObserver. method=" + methodName);
            }
        }
        if (methodDescriptor.getRpcType() != MethodDescriptor.RpcType.UNARY) {
            if (MethodDescriptor.RpcType.SERVER_STREAM == methodDescriptor.getRpcType() && !secondParameterStream) {
                throw new IllegalStateException("method params error:server stream's second param must be StreamObserver. method=" + methodName);
            }
            if (returnClassProtobuf) {
                if (javaParameterCount > 0) {
                    throw new IllegalStateException("method params error: both normal and protobuf param found. method=" + methodName);
                }
            } else if (protobufParameterCount > 0) {
                throw new IllegalStateException("method params error method=" + methodName);
            }
        } else {
            boolean ignore;
            if (streamParameterCount > 0) {
                throw new IllegalStateException("method params error: unary method should not contain any StreamObserver. method=" + methodName);
            }
            if (protobufParameterCount > 0 && returnClassProtobuf) {
                return false;
            }
            if (ReflectionPackableMethod.isMono(returnClass) || ReflectionPackableMethod.isRx(returnClass)) {
                return false;
            }
            if (protobufParameterCount <= 0 && !returnClassProtobuf) {
                return true;
            }
            if (GRPC_ASYNC_RETURN_CLASS.equalsIgnoreCase(returnClass.getName()) && protobufParameterCount == 1) {
                return false;
            }
            if (TRI_ASYNC_RETURN_CLASS.equalsIgnoreCase(returnClass.getName())) {
                Class actualReturnClass = (Class)((ParameterizedType)methodDescriptor.getMethod().getGenericReturnType()).getActualTypeArguments()[0];
                boolean actualReturnClassProtobuf = ProtobufUtils.isProtobufClass(actualReturnClass);
                if (actualReturnClassProtobuf && protobufParameterCount == 1) {
                    return false;
                }
                if (!actualReturnClassProtobuf && protobufParameterCount == 0) {
                    return true;
                }
            }
            if (ignore = ReflectionPackableMethod.checkNeedIgnore(returnClass)) {
                return protobufParameterCount != 1;
            }
            throw new IllegalStateException("method params error method=" + methodName);
        }
        return javaParameterCount > 0;
    }

    static boolean checkNeedIgnore(Class<?> returnClass) {
        return Iterator.class.isAssignableFrom(returnClass);
    }

    static boolean isMono(Class<?> clz) {
        return REACTOR_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    static boolean isRx(Class<?> clz) {
        return RX_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    private static String convertHessianFromWrapper(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            return "hessian2";
        }
        return serializeType;
    }

    static Class<?> obtainActualTypeInStreamObserver(Type typeInStreamObserver) {
        return (Class)(typeInStreamObserver instanceof ParameterizedType ? ((ParameterizedType)typeInStreamObserver).getRawType() : typeInStreamObserver);
    }

    @Override
    public Pack getRequestPack() {
        return this.requestPack;
    }

    @Override
    public Pack getResponsePack() {
        return this.responsePack;
    }

    @Override
    public UnPack getResponseUnpack() {
        return this.responseUnpack;
    }

    @Override
    public UnPack getRequestUnpack() {
        return this.requestUnpack;
    }

    private static class WrapRequestPack
    implements Pack {
        private final String serialize;
        private final MultipleSerialization multipleSerialization;
        private final String[] argumentsType;
        private final Class<?>[] actualRequestTypes;
        private final URL url;
        private final boolean singleArgument;

        private WrapRequestPack(MultipleSerialization multipleSerialization, URL url, String serialize, Class<?>[] actualRequestTypes, boolean singleArgument) {
            this.url = url;
            this.serialize = this.convertHessianToWrapper(serialize);
            this.multipleSerialization = multipleSerialization;
            this.actualRequestTypes = actualRequestTypes;
            this.argumentsType = (String[])Stream.of(actualRequestTypes).map(Class::getName).toArray(String[]::new);
            this.singleArgument = singleArgument;
        }

        @Override
        public byte[] pack(Object obj) throws IOException {
            Object[] arguments = this.singleArgument ? new Object[]{obj} : (Object[])obj;
            TripleCustomerProtocolWrapper.TripleRequestWrapper.Builder builder = TripleCustomerProtocolWrapper.TripleRequestWrapper.Builder.newBuilder();
            builder.setSerializeType(this.serialize);
            for (String type : this.argumentsType) {
                builder.addArgTypes(type);
            }
            if (this.actualRequestTypes == null || this.actualRequestTypes.length == 0) {
                return builder.build().toByteArray();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (int i = 0; i < arguments.length; ++i) {
                Object argument = arguments[i];
                this.multipleSerialization.serialize(this.url, this.serialize, this.actualRequestTypes[i], argument, bos);
                builder.addArgs(bos.toByteArray());
                bos.reset();
            }
            return builder.build().toByteArray();
        }

        private String convertHessianToWrapper(String serializeType) {
            if ("hessian2".equals(serializeType)) {
                return "hessian4";
            }
            return serializeType;
        }
    }

    private static class WrapResponseUnpack
    implements WrapperUnPack {
        private final MultipleSerialization serialization;
        private final URL url;
        private final Class<?> returnClass;
        private final Collection<String> allSerialize;

        private WrapResponseUnpack(MultipleSerialization serialization, URL url, Collection<String> allSerialize, Class<?> returnClass) {
            this.serialization = serialization;
            this.url = url;
            this.returnClass = returnClass;
            this.allSerialize = allSerialize;
        }

        @Override
        public Object unpack(byte[] data) throws IOException, ClassNotFoundException {
            return this.unpack(data, false);
        }

        @Override
        public Object unpack(byte[] data, boolean isReturnTriException) throws IOException, ClassNotFoundException {
            TripleCustomerProtocolWrapper.TripleResponseWrapper wrapper = TripleCustomerProtocolWrapper.TripleResponseWrapper.parseFrom(data);
            String serializeType = ReflectionPackableMethod.convertHessianFromWrapper(wrapper.getSerializeType());
            CodecSupport.checkSerialization(serializeType, this.allSerialize);
            ByteArrayInputStream bais = new ByteArrayInputStream(wrapper.getData());
            if (isReturnTriException) {
                return this.serialization.deserialize(this.url, serializeType, Exception.class, bais);
            }
            return this.serialization.deserialize(this.url, serializeType, this.returnClass, bais);
        }
    }

    private static class WrapResponsePack
    implements Pack {
        private final MultipleSerialization multipleSerialization;
        private final URL url;
        private final Class<?> actualResponseType;
        String requestSerialize;

        private WrapResponsePack(MultipleSerialization multipleSerialization, URL url, String defaultSerialize, Class<?> actualResponseType) {
            this.multipleSerialization = multipleSerialization;
            this.url = url;
            this.actualResponseType = actualResponseType;
            this.requestSerialize = defaultSerialize;
        }

        @Override
        public byte[] pack(Object obj) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.multipleSerialization.serialize(this.url, this.requestSerialize, this.actualResponseType, obj, bos);
            return TripleCustomerProtocolWrapper.TripleResponseWrapper.Builder.newBuilder().setSerializeType(this.requestSerialize).setType(this.actualResponseType.getName()).setData(bos.toByteArray()).build().toByteArray();
        }
    }

    private class WrapRequestUnpack
    implements WrapperUnPack {
        private final MultipleSerialization serialization;
        private final URL url;
        private final Class<?>[] actualRequestTypes;
        private final Collection<String> allSerialize;

        private WrapRequestUnpack(MultipleSerialization serialization, URL url, Collection<String> allSerialize, Class<?>[] actualRequestTypes) {
            this.serialization = serialization;
            this.url = url;
            this.actualRequestTypes = actualRequestTypes;
            this.allSerialize = allSerialize;
        }

        @Override
        public Object unpack(byte[] data, boolean isReturnTriException) throws IOException, ClassNotFoundException {
            TripleCustomerProtocolWrapper.TripleRequestWrapper wrapper = TripleCustomerProtocolWrapper.TripleRequestWrapper.parseFrom(data);
            String wrapperSerializeType = ReflectionPackableMethod.convertHessianFromWrapper(wrapper.getSerializeType());
            CodecSupport.checkSerialization(wrapperSerializeType, this.allSerialize);
            Object[] ret = new Object[wrapper.getArgs().size()];
            ((WrapResponsePack)((ReflectionPackableMethod)ReflectionPackableMethod.this).responsePack).requestSerialize = wrapper.getSerializeType();
            for (int i = 0; i < wrapper.getArgs().size(); ++i) {
                ByteArrayInputStream bais = new ByteArrayInputStream(wrapper.getArgs().get(i));
                ret[i] = this.serialization.deserialize(this.url, wrapper.getSerializeType(), this.actualRequestTypes[i], bais);
            }
            return ret;
        }
    }
}

