/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ByteBufferBackedChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;

public class Http2ProtocolDetector
implements ProtocolDetector {
    private final ChannelBuffer clientPrefaceString = new ByteBufferBackedChannelBuffer(Http2CodecUtil.connectionPrefaceBuf().nioBuffer());

    @Override
    public ProtocolDetector.Result detect(ChannelBuffer in) {
        int prefaceLen = this.clientPrefaceString.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals(in, this.clientPrefaceString, bytesRead)) {
            return ProtocolDetector.Result.unrecognized();
        }
        if (bytesRead == prefaceLen) {
            return ProtocolDetector.Result.recognized();
        }
        return ProtocolDetector.Result.needMoreData();
    }
}

