/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.config.model;

import java.util.Map;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.ConditionRouterRule;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.MultiDestConditionRouterRule;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ConditionRuleParser {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ConditionRuleParser.class);

    public static AbstractRouterRule parse(String rawRule) {
        AbstractRouterRule rule;
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Map map = (Map)yaml.load(rawRule);
        String confVersion = (String)map.get("configVersion");
        if (confVersion != null && confVersion.toLowerCase().startsWith("v3.1")) {
            rule = MultiDestConditionRouterRule.parseFromMap(map);
            if (CollectionUtils.isEmpty(((MultiDestConditionRouterRule)rule).getConditions())) {
                rule.setValid(false);
            }
        } else if (confVersion != null && confVersion.compareToIgnoreCase("v3.1") > 0) {
            logger.warn("2-15", "Invalid condition config version number.", "", "Ignore this configuration. Only v3.1 and below are supported in this release");
            rule = null;
        } else {
            rule = ConditionRouterRule.parseFromMap(map);
            if (CollectionUtils.isEmpty(((ConditionRouterRule)rule).getConditions())) {
                rule.setValid(false);
            }
        }
        if (rule != null) {
            rule.setRawRule(rawRule);
        }
        return rule;
    }
}

