/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.condition.ConditionStateRouter;
import org.apache.dubbo.rpc.cluster.router.condition.MultiDestConditionRouter;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.ConditionRouterRule;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.ConditionRuleParser;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.MultiDestCondition;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.MultiDestConditionRouterRule;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.TailStateRouter;

public abstract class ListenableStateRouter<T>
extends AbstractStateRouter<T>
implements ConfigurationListener {
    public static final String NAME = "LISTENABLE_ROUTER";
    public static final String RULE_SUFFIX = ".condition-router";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ListenableStateRouter.class);
    private volatile AbstractRouterRule routerRule;
    private volatile List<ConditionStateRouter<T>> conditionRouters = Collections.emptyList();
    private volatile List<MultiDestConditionRouter<T>> multiDestConditionRouters = Collections.emptyList();
    private final String ruleKey;

    public ListenableStateRouter(URL url, String ruleKey) {
        super(url);
        this.setForce(false);
        this.init(ruleKey);
        this.ruleKey = ruleKey;
    }

    @Override
    public synchronized void process(ConfigChangedEvent event) {
        if (logger.isInfoEnabled()) {
            logger.info("Notification of condition rule, change type is: " + (Object)((Object)event.getChangeType()) + ", raw rule is:\n " + event.getContent());
        }
        if (event.getChangeType().equals((Object)ConfigChangeType.DELETED)) {
            this.routerRule = null;
            this.conditionRouters = Collections.emptyList();
            this.multiDestConditionRouters = Collections.emptyList();
        } else {
            try {
                this.routerRule = ConditionRuleParser.parse(event.getContent());
                this.generateConditions(this.routerRule);
            }
            catch (Exception e) {
                logger.error("2-15", "Failed to parse the raw condition rule", "", "Failed to parse the raw condition rule and it will not take effect, please check if the condition rule matches with the template, the raw rule is:\n " + event.getContent(), e);
            }
        }
    }

    @Override
    public BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (CollectionUtils.isEmpty(invokers) || this.conditionRouters.size() == 0 && this.multiDestConditionRouters.size() == 0) {
            if (needToPrintMessage) {
                messageHolder.set("Directly return. Reason: Invokers from previous router is empty or conditionRouters is empty.");
            }
            return invokers;
        }
        StringBuilder resultMessage = null;
        if (needToPrintMessage) {
            resultMessage = new StringBuilder();
        }
        List<AbstractStateRouter> routers = this.routerRule instanceof MultiDestConditionRouterRule ? this.multiDestConditionRouters : this.conditionRouters;
        for (AbstractStateRouter router : routers) {
            invokers = router.route(invokers, url, invocation, needToPrintMessage, nodeHolder);
            if (!needToPrintMessage) continue;
            resultMessage.append(messageHolder.get());
        }
        if (needToPrintMessage) {
            messageHolder.set(resultMessage.toString());
        }
        return invokers;
    }

    @Override
    public boolean isForce() {
        return this.routerRule != null && this.routerRule.isForce();
    }

    private boolean isRuleRuntime() {
        return this.routerRule != null && this.routerRule.isValid() && this.routerRule.isRuntime();
    }

    private void generateConditions(AbstractRouterRule rule) {
        block4: {
            block3: {
                if (rule == null || !rule.isValid()) {
                    return;
                }
                if (!(rule instanceof ConditionRouterRule)) break block3;
                this.conditionRouters = ((ConditionRouterRule)rule).getConditions().stream().map(condition -> new ConditionStateRouter(this.getUrl(), (String)condition, rule.isForce(), rule.isEnabled())).collect(Collectors.toList());
                for (ConditionStateRouter conditionRouter : this.conditionRouters) {
                    conditionRouter.setNextRouter(TailStateRouter.getInstance());
                }
                break block4;
            }
            if (!(rule instanceof MultiDestConditionRouterRule)) break block4;
            this.multiDestConditionRouters = ((MultiDestConditionRouterRule)rule).getConditions().stream().map(condition -> new MultiDestConditionRouter(this.getUrl(), (MultiDestCondition)condition, rule.isForce(), rule.isEnabled())).collect(Collectors.toList());
            for (MultiDestConditionRouter conditionRouter : this.multiDestConditionRouters) {
                conditionRouter.setNextRouter(TailStateRouter.getInstance());
            }
        }
    }

    private synchronized void init(String ruleKey) {
        if (StringUtils.isEmpty(ruleKey)) {
            return;
        }
        String routerKey = ruleKey + RULE_SUFFIX;
        this.getRuleRepository().addListener(routerKey, this);
        String rule = this.getRuleRepository().getRule(routerKey, "dubbo");
        if (StringUtils.isNotEmpty(rule)) {
            this.process(new ConfigChangedEvent(routerKey, "dubbo", rule));
        }
    }

    @Override
    public void stop() {
        this.getRuleRepository().removeListener(this.ruleKey + RULE_SUFFIX, this);
    }
}

