/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.io.Serializable;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.StatusRpcException;

public class TriRpcStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TriRpcStatus OK = TriRpcStatus.fromCode(Code.OK);
    public static final TriRpcStatus UNKNOWN = TriRpcStatus.fromCode(Code.UNKNOWN);
    public static final TriRpcStatus INTERNAL = TriRpcStatus.fromCode(Code.INTERNAL);
    public static final TriRpcStatus NOT_FOUND = TriRpcStatus.fromCode(Code.NOT_FOUND);
    public static final TriRpcStatus CANCELLED = TriRpcStatus.fromCode(Code.CANCELLED);
    public static final TriRpcStatus UNAVAILABLE = TriRpcStatus.fromCode(Code.UNAVAILABLE);
    public static final TriRpcStatus UNIMPLEMENTED = TriRpcStatus.fromCode(Code.UNIMPLEMENTED);
    public static final TriRpcStatus DEADLINE_EXCEEDED = TriRpcStatus.fromCode(Code.DEADLINE_EXCEEDED);
    public final Code code;
    public final Throwable cause;
    public final String description;

    public TriRpcStatus(Code code, Throwable cause, String description) {
        this.code = code;
        this.cause = cause;
        this.description = description;
    }

    public static TriRpcStatus fromCode(int code) {
        return TriRpcStatus.fromCode(Code.fromCode(code));
    }

    public static TriRpcStatus fromCode(Code code) {
        return new TriRpcStatus(code, null, null);
    }

    public static TriRpcStatus getStatus(Throwable throwable) {
        return TriRpcStatus.getStatus(throwable, null);
    }

    public static TriRpcStatus getStatus(Throwable throwable, String description) {
        if (throwable instanceof HttpStatusException) {
            int statusCode = ((HttpStatusException)throwable).getStatusCode();
            return new TriRpcStatus(TriRpcStatus.httpStatusToGrpcCode(statusCode), throwable, description);
        }
        if (throwable instanceof StatusRpcException) {
            return ((StatusRpcException)throwable).getStatus();
        }
        if (throwable instanceof RpcException) {
            RpcException rpcException = (RpcException)throwable;
            Code code = TriRpcStatus.dubboCodeToTriCode(rpcException.getCode());
            return new TriRpcStatus(code, throwable, description);
        }
        if (throwable instanceof TimeoutException) {
            return new TriRpcStatus(Code.DEADLINE_EXCEEDED, throwable, description);
        }
        return new TriRpcStatus(Code.UNKNOWN, throwable, description);
    }

    public static int triCodeToDubboCode(Code triCode) {
        int code;
        switch (triCode.ordinal()) {
            case 4: {
                code = 2;
                break;
            }
            case 7: {
                code = 4;
                break;
            }
            case 14: {
                code = 1;
                break;
            }
            case 12: {
                code = 11;
                break;
            }
            default: {
                code = 0;
            }
        }
        return code;
    }

    public static Code dubboCodeToTriCode(int rpcExceptionCode) {
        Code code;
        switch (rpcExceptionCode) {
            case 2: 
            case 8: {
                code = Code.DEADLINE_EXCEEDED;
                break;
            }
            case 4: {
                code = Code.PERMISSION_DENIED;
                break;
            }
            case 13: {
                code = Code.UNAUTHENTICATED;
                break;
            }
            case 1: 
            case 7: {
                code = Code.UNAVAILABLE;
                break;
            }
            case 11: {
                code = Code.NOT_FOUND;
                break;
            }
            case 5: {
                code = Code.INTERNAL;
                break;
            }
            default: {
                code = Code.UNKNOWN;
            }
        }
        return code;
    }

    public static String limitSizeTo1KB(String desc) {
        if (desc.length() < 1024) {
            return desc;
        }
        return desc.substring(0, 1024);
    }

    public static String decodeMessage(String raw) {
        if (StringUtils.isEmpty(raw)) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(raw);
    }

    public static String encodeMessage(String raw) {
        if (StringUtils.isEmpty(raw)) {
            return "";
        }
        return TriRpcStatus.encodeComponent(raw);
    }

    private static String encodeComponent(String raw) {
        QueryStringEncoder encoder = new QueryStringEncoder("");
        encoder.addParam("", raw);
        return encoder.toString().substring(2);
    }

    public static Code httpStatusToGrpcCode(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Code.INTERNAL;
        }
        if (httpStatusCode == HttpResponseStatus.BAD_REQUEST.code() || httpStatusCode == HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.code()) {
            return Code.INTERNAL;
        }
        if (httpStatusCode == HttpResponseStatus.UNAUTHORIZED.code()) {
            return Code.UNAUTHENTICATED;
        }
        if (httpStatusCode == HttpResponseStatus.FORBIDDEN.code()) {
            return Code.PERMISSION_DENIED;
        }
        if (httpStatusCode == HttpResponseStatus.NOT_FOUND.code()) {
            return Code.UNIMPLEMENTED;
        }
        if (httpStatusCode == HttpResponseStatus.BAD_GATEWAY.code() || httpStatusCode == HttpResponseStatus.TOO_MANY_REQUESTS.code() || httpStatusCode == HttpResponseStatus.SERVICE_UNAVAILABLE.code() || httpStatusCode == HttpResponseStatus.GATEWAY_TIMEOUT.code()) {
            return Code.UNAVAILABLE;
        }
        return Code.UNKNOWN;
    }

    public static int grpcCodeToHttpStatus(Code code) {
        switch (code.ordinal()) {
            case 0: {
                return HttpResponseStatus.OK.code();
            }
            case 1: {
                return 499;
            }
            case 2: 
            case 13: 
            case 15: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
            }
            case 3: 
            case 9: 
            case 11: {
                return HttpResponseStatus.BAD_REQUEST.code();
            }
            case 4: {
                return HttpResponseStatus.GATEWAY_TIMEOUT.code();
            }
            case 5: {
                return HttpResponseStatus.NOT_FOUND.code();
            }
            case 6: 
            case 10: {
                return HttpResponseStatus.CONFLICT.code();
            }
            case 7: {
                return HttpResponseStatus.FORBIDDEN.code();
            }
            case 8: {
                return HttpResponseStatus.TOO_MANY_REQUESTS.code();
            }
            case 12: {
                return HttpResponseStatus.NOT_IMPLEMENTED.code();
            }
            case 14: {
                return HttpResponseStatus.SERVICE_UNAVAILABLE.code();
            }
            case 16: {
                return HttpResponseStatus.UNAUTHORIZED.code();
            }
        }
        return -1;
    }

    public boolean isOk() {
        return Code.isOk(this.code.code);
    }

    public TriRpcStatus withCause(Throwable cause) {
        return new TriRpcStatus(this.code, cause, this.description);
    }

    public TriRpcStatus withDescription(String description) {
        return new TriRpcStatus(this.code, this.cause, description);
    }

    public TriRpcStatus appendDescription(String description) {
        if (this.description == null) {
            return this.withDescription(description);
        }
        String newDescription = this.description + "\n" + description;
        return this.withDescription(newDescription);
    }

    public StatusRpcException asException() {
        return new StatusRpcException(this);
    }

    public String toEncodedMessage() {
        String output = TriRpcStatus.limitSizeTo1KB(this.toMessage());
        return TriRpcStatus.encodeComponent(output);
    }

    public String toMessageWithoutCause() {
        if (this.description != null) {
            return String.format("%s : %s", new Object[]{this.code, this.description});
        }
        return this.code.toString();
    }

    public String toMessage() {
        String msg = "";
        if (this.cause == null) {
            msg = msg + this.description;
        } else {
            String placeHolder = this.description == null ? "" : this.description;
            msg = msg + StringUtils.toString(placeHolder, this.cause);
        }
        return msg;
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        public final int code;

        private Code(int code) {
            this.code = code;
        }

        public static boolean isOk(Integer status) {
            return status == Code.OK.code;
        }

        public static Code fromCode(int code) {
            for (Code value : Code.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new IllegalStateException("Can not find status for code: " + code);
        }
    }
}

