/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler;

public class WebSocketServerUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private final List<Class<? extends ChannelHandler>> shouldRemoveChannelHandlers;
    private final ChannelHandler[] channelHandlers;

    public WebSocketServerUpgradeCodec(List<Class<? extends ChannelHandler>> shouldRemoveChannelHandlers, ChannelHandler ... channelHandlers) {
        this.shouldRemoveChannelHandlers = shouldRemoveChannelHandlers;
        this.channelHandlers = channelHandlers;
    }

    @Override
    public Collection<CharSequence> requiredUpgradeHeaders() {
        return Collections.emptyList();
    }

    @Override
    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
        if (this.shouldRemoveChannelHandlers != null) {
            for (Class clazz : this.shouldRemoveChannelHandlers) {
                ctx.pipeline().remove(clazz);
            }
        }
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                ctx.pipeline().addLast(channelHandler);
            }
        }
        return false;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
    }
}

