/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.dubbo.remoting.http12.command.HttpWriteQueue;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.command.Http2WriteQueueChannel;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameHandler;
import org.apache.dubbo.remoting.websocket.WebSocketServerTransportListenerFactory;
import org.apache.dubbo.remoting.websocket.WebSocketTransportListener;
import org.apache.dubbo.remoting.websocket.netty4.NettyWebSocketChannel;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class WebSocketProtocolSelectorHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final URL url;
    private final FrameworkModel frameworkModel;
    private final TripleConfig tripleConfig;
    private final WebSocketServerTransportListenerFactory defaultWebSocketServerTransportListenerFactory;

    public WebSocketProtocolSelectorHandler(URL url, FrameworkModel frameworkModel, TripleConfig tripleConfig, WebSocketServerTransportListenerFactory defaultWebSocketServerTransportListenerFactory) {
        this.url = url;
        this.frameworkModel = frameworkModel;
        this.tripleConfig = tripleConfig;
        this.defaultWebSocketServerTransportListenerFactory = defaultWebSocketServerTransportListenerFactory;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        H2StreamChannel streamChannel = new NettyWebSocketChannel(ctx.channel(), this.tripleConfig);
        HttpWriteQueueHandler writeQueueHandler = ctx.channel().pipeline().get(HttpWriteQueueHandler.class);
        if (writeQueueHandler != null) {
            HttpWriteQueue writeQueue = writeQueueHandler.getWriteQueue();
            streamChannel = new Http2WriteQueueChannel(streamChannel, writeQueue);
        }
        WebSocketTransportListener webSocketTransportListener = this.defaultWebSocketServerTransportListenerFactory.newInstance(streamChannel, this.url, this.frameworkModel);
        ctx.channel().closeFuture().addListener(future -> webSocketTransportListener.close());
        ctx.pipeline().addLast(new NettyHttp2FrameHandler(streamChannel, webSocketTransportListener)).remove(this);
        ctx.fireChannelRead(msg.retain());
    }
}

