/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.LimitedByteBufOutputStream;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpChannelFutureListener;

public class NettyWebSocketChannel
implements H2StreamChannel {
    private final Channel channel;
    private final TripleConfig tripleConfig;

    public NettyWebSocketChannel(Channel channel, TripleConfig tripleConfig) {
        this.channel = channel;
        this.tripleConfig = tripleConfig;
    }

    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.channel.close().addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new Http2OutputMessageFrame(new LimitedByteBufOutputStream(this.channel.alloc().buffer(), this.tripleConfig.getMaxResponseBodySizeOrDefault()), endStream);
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.channel.write(httpMetadata).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.channel.write(httpOutputMessage).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    @Override
    public void flush() {
        this.channel.flush();
    }
}

