/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslContext;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.dubbo.netty.shaded.io.netty.util.AttributeKey;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;

public class SslClientTlsHandler
extends ChannelInboundHandlerAdapter {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SslClientTlsHandler.class);
    private static final AttributeKey<SSLSession> SSL_SESSION_KEY = AttributeKey.valueOf("ssl-session");
    private final SslContext sslContext;

    public SslClientTlsHandler(URL url) {
        this(SslContexts.buildClientSslContext(url));
    }

    public SslClientTlsHandler(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
        ctx.pipeline().addAfter(ctx.name(), null, new SslHandler(sslEngine, false));
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                SSLSession session = ctx.pipeline().get(SslHandler.class).engine().getSession();
                logger.info("TLS negotiation succeed with: " + session.getPeerHost());
                ctx.pipeline().remove(this);
                ctx.channel().attr(SSL_SESSION_KEY).set(session);
            } else {
                logger.error("99-0", "unknown error in remoting module", "", "TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                ctx.fireExceptionCaught(handshakeEvent.cause());
            }
        }
    }
}

