/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.dubbo.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.dubbo.netty.shaded.io.netty.util.AttributeKey;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

@ChannelHandler.Sharable
public class NettyServerHandler
extends ChannelDuplexHandler {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyServerHandler.class);
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private static final AttributeKey<SSLSession> SSL_SESSION_KEY = AttributeKey.valueOf("ssl-session");
    private final URL url;
    private final ChannelHandler handler;

    public NettyServerHandler(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        if (channel != null) {
            this.channels.put(NetUtils.toAddressString(channel.getRemoteAddress()), channel);
        }
        this.handler.connected(channel);
        if (logger.isInfoEnabled() && channel != null) {
            logger.info("The connection {} of {} -> {} is established.", ch, channel.getRemoteAddressKey(), channel.getLocalAddressKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            this.channels.remove(NetUtils.toAddressString(channel.getRemoteAddress()));
            this.handler.disconnected(channel);
        }
        finally {
            NettyChannel.removeChannel(ch);
        }
        if (logger.isInfoEnabled()) {
            logger.info("The connection {} of {} -> {} is disconnected.", ch, channel.getRemoteAddressKey(), channel.getLocalAddressKey());
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        this.handler.received(channel, msg);
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        this.handler.sent(channel, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        SslHandshakeCompletionEvent handshakeEvent;
        if (evt instanceof IdleStateEvent) {
            NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
            try {
                logger.info("IdleStateEvent triggered, close channel " + channel);
                channel.close();
            }
            finally {
                NettyChannel.removeChannelIfDisconnected(ctx.channel());
            }
        }
        super.userEventTriggered(ctx, evt);
        if (evt instanceof SslHandshakeCompletionEvent && (handshakeEvent = (SslHandshakeCompletionEvent)evt).isSuccess()) {
            NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
            channel.setAttribute("ssl-session", ctx.channel().attr(SSL_SESSION_KEY).get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            this.handler.caught(channel, cause);
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ch);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("6-4", "", "", channel == null ? String.format("The connection %s has exception.", ch) : String.format("The connection %s of %s -> %s has exception.", ch, channel.getRemoteAddressKey(), channel.getLocalAddressKey()), cause);
        }
    }
}

