/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.netty.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.dubbo.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInitializer;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.AbstractPortUnificationServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.NettyChannelHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyPortUnificationServerHandler;

public class NettyPortUnificationServer
extends AbstractPortUnificationServer {
    private final int serverShutdownTimeoutMills;
    private ServerBootstrap bootstrap;
    private org.apache.dubbo.netty.shaded.io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final Map<String, Channel> dubboChannels = new ConcurrentHashMap<String, Channel>();

    public NettyPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap(handler, url));
        this.serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout(this.getUrl().getOrDefaultModuleModel());
    }

    @Override
    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        super.addSupportedProtocol(url, ChannelHandlers.wrap(handler, url));
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.doClose();
        }
    }

    public void bind() throws Throwable {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    @Override
    public void doOpen0() {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), "NettyServerWorker");
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                NettyChannelHandler nettyChannelHandler = new NettyChannelHandler(NettyPortUnificationServer.this.dubboChannels, NettyPortUnificationServer.this.getUrl(), NettyPortUnificationServer.this);
                NettyPortUnificationServerHandler puHandler = new NettyPortUnificationServerHandler(NettyPortUnificationServer.this.getUrl(), true, NettyPortUnificationServer.this.getProtocols(), NettyPortUnificationServer.this, NettyPortUnificationServer.this.getSupportedUrls(), NettyPortUnificationServer.this.getSupportedHandlers());
                p.addLast("channel-handler", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)nettyChannelHandler);
                p.addLast("negotiation-protocol", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)puHandler);
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.getUrl().getParameter("anyhost", false) || NetUtils.isInvalidLocalHost(bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        try {
            ChannelFuture channelFuture = this.bootstrap.bind(bindAddress);
            channelFuture.syncUninterruptibly();
            this.channel = channelFuture.channel();
        }
        catch (Throwable t) {
            this.closeBootstrap();
            throw t;
        }
    }

    private void closeBootstrap() {
        try {
            if (this.bootstrap != null) {
                long timeout = ConfigurationUtils.reCalShutdownTime(this.serverShutdownTimeoutMills);
                long quietPeriod = Math.min(2000L, timeout);
                Future<?> bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                Future<?> workerGroupShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
                workerGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    @Override
    public void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", "Interrupted while shutting down", e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        this.logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        for (WireProtocol protocol : this.getProtocols().values()) {
            protocol.close();
        }
        this.closeBootstrap();
    }

    @Override
    protected int getChannelsSize() {
        return this.dubboChannels.size();
    }

    @Override
    public boolean isBound() {
        return this.channel.isActive();
    }

    @Override
    public Collection<Channel> getChannels() {
        ArrayList<Channel> chs = new ArrayList<Channel>(this.dubboChannels.size());
        chs.addAll(this.dubboChannels.values());
        return chs;
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.dubboChannels.get(NetUtils.toAddressString(remoteAddress));
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public boolean canHandleIdle() {
        return true;
    }
}

