/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.netty.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInitializer;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.InsecureQuicTokenHandler;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicTokenHandler;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.http3.Http3SslContexts;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.Http3Helper;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;

public class NettyHttp3Server
extends AbstractServer {
    private Map<String, Channel> channels;
    private Bootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private org.apache.dubbo.netty.shaded.io.netty.channel.Channel channel;
    private final Consumer<ChannelPipeline> pipelineConfigurator = (Consumer)this.getUrl().getAttribute("http3PipelineConfigurator");
    private final int serverShutdownTimeoutMills;

    public NettyHttp3Server(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap(handler, url));
        Objects.requireNonNull(this.pipelineConfigurator, "pipelineConfigurator should be set");
        this.serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout(this.getUrl().getOrDefaultModuleModel());
    }

    @Override
    protected void doOpen() throws Throwable {
        this.bootstrap = new Bootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
        final NettyServerHandler nettyServerHandler = new NettyServerHandler(this.getUrl(), this);
        this.channels = nettyServerHandler.getChannels();
        try {
            ChannelFuture channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.bossGroup)).channel(NioDatagramChannel.class)).handler(((QuicServerCodecBuilder)((QuicServerCodecBuilder)Http3Helper.configCodec(Http3.newQuicServerCodecBuilder(), this.getUrl())).sslContext(Http3SslContexts.buildServerSslContext(this.getUrl()))).tokenHandler((QuicTokenHandler)InsecureQuicTokenHandler.INSTANCE).handler((org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)new ChannelInitializer<QuicChannel>(){

                @Override
                protected void initChannel(QuicChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    NettyHttp3Server.this.pipelineConfigurator.accept(pipeline);
                    pipeline.addLast(nettyServerHandler);
                }
            }).build())).bind(this.getBindAddress());
            channelFuture.syncUninterruptibly();
            this.channel = channelFuture.channel();
        }
        catch (Throwable t) {
            this.closeBootstrap();
            throw t;
        }
    }

    @Override
    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        this.logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        this.closeBootstrap();
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    private void closeBootstrap() {
        try {
            if (this.bootstrap != null) {
                long timeout = ConfigurationUtils.reCalShutdownTime(this.serverShutdownTimeoutMills);
                long quietPeriod = Math.min(2000L, timeout);
                Future<?> bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    @Override
    protected int getChannelsSize() {
        return this.channels.size();
    }

    @Override
    public Collection<Channel> getChannels() {
        return new ArrayList<Channel>(this.channels.values());
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString(remoteAddress));
    }

    @Override
    public boolean canHandleIdle() {
        return true;
    }

    @Override
    public boolean isBound() {
        return this.channel.isActive();
    }
}

