/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.netty.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInitializer;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannelBootstrap;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.http3.Http3SslContexts;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.Http3Helper;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;

public final class NettyHttp3ConnectionClient
extends AbstractNettyConnectionClient {
    private Consumer<ChannelPipeline> pipelineConfigurator;
    private AtomicReference<Channel> datagramChannel;
    private QuicChannelBootstrap bootstrap;

    public NettyHttp3ConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void initConnectionClient() {
        super.initConnectionClient();
        this.datagramChannel = new AtomicReference();
        this.pipelineConfigurator = (Consumer)this.getUrl().getAttribute("http3PipelineConfigurator");
        Objects.requireNonNull(this.pipelineConfigurator, "pipelineConfigurator should be set");
    }

    @Override
    protected void initBootstrap() throws Exception {
        final org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler codec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)Http3Helper.configCodec(Http3.newQuicClientCodecBuilder(), this.getUrl())).sslContext(Http3SslContexts.buildClientSslContext(this.getUrl()))).build();
        Channel nettyDatagramChannel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.getConnectTimeout())).group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).channel(NioDatagramChannel.class)).handler(new ChannelInitializer<NioDatagramChannel>(){

            @Override
            protected void initChannel(NioDatagramChannel ch) {
                ch.pipeline().addLast(codec);
            }
        })).bind(0).sync().channel();
        this.datagramChannel.set(nettyDatagramChannel);
        nettyDatagramChannel.closeFuture().addListener(channelFuture -> this.datagramChannel.set(null));
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler(this);
        this.bootstrap = QuicChannel.newBootstrap((Channel)nettyDatagramChannel).handler((org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)new ChannelInitializer<QuicChannel>(){

            @Override
            protected void initChannel(QuicChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler[]{new Http3ClientConnectionHandler()});
                pipeline.addLast("connectionHandler", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)connectionHandler);
                NettyHttp3ConnectionClient.this.pipelineConfigurator.accept(pipeline);
                ch.closeFuture().addListener(channelFuture -> NettyHttp3ConnectionClient.this.clearNettyChannel());
            }
        }).remoteAddress((SocketAddress)this.getConnectAddress());
    }

    @Override
    protected ChannelFuture performConnect() {
        Channel channel = this.getNettyDatagramChannel();
        if (channel == null) {
            return null;
        }
        ChannelPromise promise = channel.newPromise();
        GenericFutureListener<Future> listener = f -> {
            if (f.isSuccess()) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(f.cause());
            }
        };
        this.bootstrap.connect().addListener(listener);
        return promise;
    }

    @Override
    protected void performClose() {
        super.performClose();
        Channel current = this.getNettyDatagramChannel();
        if (current != null) {
            current.close();
        }
        this.datagramChannel.set(null);
    }

    private Channel getNettyDatagramChannel() {
        return this.datagramChannel.get();
    }
}

