/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.epoll.Epoll;
import org.apache.dubbo.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.dubbo.remoting.Constants;

public class NettyEventLoopFactory {
    public static final GlobalResourceInitializer<EventLoopGroup> NIO_EVENT_LOOP_GROUP = new GlobalResourceInitializer<EventLoopGroup>(() -> NettyEventLoopFactory.eventLoopGroup(Constants.DEFAULT_IO_THREADS, "NettyClientWorker"), eventLoopGroup -> eventLoopGroup.shutdownGracefully());

    public static EventLoopGroup eventLoopGroup(int threads, String threadFactoryName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadFactoryName, true);
        return NettyEventLoopFactory.shouldEpoll() ? new EpollEventLoopGroup(threads, threadFactory) : new NioEventLoopGroup(threads, threadFactory);
    }

    public static Class<? extends SocketChannel> socketChannelClass() {
        return NettyEventLoopFactory.shouldEpoll() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NettyEventLoopFactory.shouldEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private static boolean shouldEpoll() {
        if (Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty("netty.epoll.enable", "false"))) {
            String osName = SystemPropertyConfigUtils.getSystemProperty("os.name");
            return osName.toLowerCase().contains("linux") && Epoll.isAvailable();
        }
        return false;
    }
}

