/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoop;
import org.apache.dubbo.netty.shaded.io.netty.util.Attribute;
import org.apache.dubbo.netty.shaded.io.netty.util.AttributeKey;
import org.apache.dubbo.remoting.api.connection.ConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

@ChannelHandler.Sharable
public class NettyConnectionHandler
extends ChannelInboundHandlerAdapter
implements ConnectionHandler {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyConnectionHandler.class);
    private static final AttributeKey<Boolean> GO_AWAY_KEY = AttributeKey.valueOf("dubbo_channel_goaway");
    private final AbstractNettyConnectionClient connectionClient;

    public NettyConnectionHandler(AbstractNettyConnectionClient connectionClient) {
        this.connectionClient = connectionClient;
    }

    @Override
    public void onGoAway(Object channel) {
        if (!(channel instanceof Channel)) {
            return;
        }
        Channel nettyChannel = (Channel)channel;
        Attribute<Boolean> attr = nettyChannel.attr(GO_AWAY_KEY);
        if (Boolean.TRUE.equals(attr.get())) {
            return;
        }
        attr.set(true);
        if (this.connectionClient != null) {
            this.connectionClient.onGoaway(nettyChannel);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Channel {} go away ,schedule reconnect", nettyChannel);
        }
        this.reconnect(nettyChannel);
    }

    @Override
    public void reconnect(Object channel) {
        if (!(channel instanceof Channel)) {
            return;
        }
        Channel nettyChannel = (Channel)channel;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection:{} is reconnecting, attempt={}", this.connectionClient, 1);
        }
        EventLoop eventLoop = nettyChannel.eventLoop();
        if (this.connectionClient.isClosed()) {
            LOGGER.info("The connection {} has been closed and will not reconnect", this.connectionClient);
            return;
        }
        eventLoop.schedule(this.connectionClient::doReconnect, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.connectionClient.getUrl(), this.connectionClient);
        if (!this.connectionClient.isClosed()) {
            this.connectionClient.onConnected(ch);
            if (LOGGER.isInfoEnabled() && channel != null) {
                LOGGER.info("The connection {} of {} -> {} is established.", ch, channel.getLocalAddressKey(), channel.getRemoteAddressKey());
            }
        } else {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.connectionClient.getUrl(), this.connectionClient);
        try {
            Attribute<Boolean> goawayAttr = ch.attr(GO_AWAY_KEY);
            if (!Boolean.TRUE.equals(goawayAttr.get())) {
                this.reconnect(ch);
            }
            if (LOGGER.isInfoEnabled() && channel != null) {
                LOGGER.info("The connection {} of {} -> {} is disconnected.", ch, channel.getLocalAddressKey(), channel.getRemoteAddressKey());
            }
        }
        finally {
            NettyChannel.removeChannel(ch);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("6-4", "", "", String.format("Channel error:%s", ctx.channel()), cause);
        ctx.close();
    }
}

