/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.netty.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.dubbo.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInitializer;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslContext;
import org.apache.dubbo.netty.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettySslContextOperator;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslClientTlsHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;
import org.apache.dubbo.remoting.utils.UrlUtils;

public final class NettyConnectionClient
extends AbstractNettyConnectionClient {
    private Bootstrap bootstrap;

    public NettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void initConnectionClient() {
        this.protocol = this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getExtension(this.getUrl().getProtocol());
        super.initConnectionClient();
    }

    @Override
    protected void initBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).remoteAddress(this.getConnectAddress()).channel(NettyEventLoopFactory.socketChannelClass());
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler(this);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.getConnectTimeout());
        final SslContext sslContext = SslContexts.buildClientSslContext(this.getUrl());
        bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                NettyChannel nettyChannel = NettyChannel.getOrAddChannel(ch, NettyConnectionClient.this.getUrl(), NettyConnectionClient.this.getChannelHandler());
                ChannelPipeline pipeline = ch.pipeline();
                NettySslContextOperator nettySslContextOperator = new NettySslContextOperator();
                if (sslContext != null) {
                    pipeline.addLast("negotiation", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)new SslClientTlsHandler(sslContext));
                }
                int heartbeat = UrlUtils.getHeartbeat(NettyConnectionClient.this.getUrl());
                pipeline.addLast("client-idle-handler", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)new IdleStateHandler(heartbeat, 0L, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast("connectionHandler", (org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler)connectionHandler);
                NettyConfigOperator operator = new NettyConfigOperator(nettyChannel, NettyConnectionClient.this.getChannelHandler());
                NettyConnectionClient.this.protocol.configClientPipeline(NettyConnectionClient.this.getUrl(), operator, nettySslContextOperator);
                ch.closeFuture().addListener(channelFuture -> NettyConnectionClient.this.clearNettyChannel());
            }
        });
        this.bootstrap = bootstrap;
    }

    @Override
    protected ChannelFuture performConnect() {
        return this.bootstrap.connect();
    }
}

