/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.dubbo.common.BatchExecutorQueue;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoop;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.remoting.exchange.support.MultiMessage;

public class Netty4BatchWriteQueue
extends BatchExecutorQueue<MessageTuple> {
    private final Channel channel;
    private final EventLoop eventLoop;
    private final Queue<ChannelPromise> promises = new LinkedList<ChannelPromise>();
    private final MultiMessage multiMessage = MultiMessage.create();

    private Netty4BatchWriteQueue(Channel channel) {
        this.channel = channel;
        this.eventLoop = channel.eventLoop();
    }

    public ChannelFuture enqueue(Object message) {
        return this.enqueue(message, this.channel.newPromise());
    }

    public ChannelFuture enqueue(Object message, ChannelPromise channelPromise) {
        MessageTuple messageTuple = new MessageTuple(message, channelPromise);
        super.enqueue(messageTuple, this.eventLoop);
        return messageTuple.channelPromise;
    }

    @Override
    protected void prepare(MessageTuple item) {
        this.multiMessage.addMessage(item.originMessage);
        this.promises.add(item.channelPromise);
    }

    @Override
    protected void flush(MessageTuple item) {
        this.prepare(item);
        Object finalMessage = this.multiMessage;
        if (this.multiMessage.size() == 1) {
            finalMessage = this.multiMessage.get(0);
        }
        this.channel.writeAndFlush(finalMessage).addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelPromise cp;
                while ((cp = (ChannelPromise)Netty4BatchWriteQueue.this.promises.poll()) != null) {
                    if (future.isSuccess()) {
                        cp.setSuccess();
                        continue;
                    }
                    cp.setFailure(future.cause());
                }
            }
        });
        this.multiMessage.removeMessages();
    }

    public static Netty4BatchWriteQueue createWriteQueue(Channel channel) {
        return new Netty4BatchWriteQueue(channel);
    }

    static class MessageTuple {
        private final Object originMessage;
        private final ChannelPromise channelPromise;

        public MessageTuple(Object originMessage, ChannelPromise channelPromise) {
            this.originMessage = originMessage;
            this.channelPromise = channelPromise;
        }
    }
}

