/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.Http3Config;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicCodecBuilder;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;

final class Http3Helper {
    Http3Helper() {
    }

    static <T extends QuicCodecBuilder<T>> T configCodec(QuicCodecBuilder<T> builder, URL url) {
        Http3Config config = ConfigManager.getProtocolOrDefault(url).getTripleOrDefault().getHttp3OrDefault();
        builder.initialMaxData((long)config.getInitialMaxDataOrDefault()).initialMaxStreamDataBidirectionalLocal((long)config.getInitialMaxStreamDataBidiLocalOrDefault()).initialMaxStreamDataBidirectionalRemote((long)config.getInitialMaxStreamDataBidiRemoteOrDefault()).initialMaxStreamDataUnidirectional((long)config.getInitialMaxStreamDataUniOrDefault()).initialMaxStreamsBidirectional(config.getInitialMaxStreamsBidiOrDefault()).initialMaxStreamsUnidirectional(config.getInitialMaxStreamsUniOrDefault());
        if (config.getRecvQueueLen() != null && config.getSendQueueLen() != null) {
            builder.datagram(config.getRecvQueueLen().intValue(), config.getSendQueueLen().intValue());
        }
        if (config.getMaxAckDelayExponent() != null) {
            builder.ackDelayExponent((long)config.getMaxAckDelayExponent().intValue());
        }
        if (config.getMaxAckDelay() != null) {
            builder.maxAckDelay((long)config.getMaxAckDelay().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getDisableActiveMigration() != null) {
            builder.activeMigration(config.getDisableActiveMigration().booleanValue());
        }
        if (config.getEnableHystart() != null) {
            builder.hystart(config.getEnableHystart().booleanValue());
        }
        if (config.getCcAlgorithm() != null) {
            if ("RENO".equalsIgnoreCase(config.getCcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.RENO);
            } else if ("BBR".equalsIgnoreCase(config.getCcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.BBR);
            }
        }
        return (T)builder;
    }
}

