/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.util.AttributeKey;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.DefaultPromise;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Promise;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Endpoint;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

public abstract class AbstractNettyConnectionClient
extends AbstractConnectionClient {
    private AtomicReference<Promise<Object>> connectingPromiseRef;
    private AtomicReference<org.apache.dubbo.netty.shaded.io.netty.channel.Channel> channelRef;
    private Promise<Void> connectedPromise;
    private Promise<Void> disconnectedPromise;
    private Promise<Void> closePromise;
    private AtomicBoolean isReconnecting;
    private ConnectionListener connectionListener;
    public static final AttributeKey<AbstractConnectionClient> CONNECTION = AttributeKey.valueOf("connection");

    public AbstractNettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void doOpen() throws Throwable {
        this.initConnectionClient();
        this.initBootstrap();
    }

    @Override
    protected void initConnectionClient() {
        this.remote = this.getConnectAddress();
        this.init = new AtomicBoolean(false);
        this.connectingPromiseRef = new AtomicReference();
        this.channelRef = new AtomicReference();
        this.connectedPromise = new DefaultPromise<Void>(GlobalEventExecutor.INSTANCE);
        this.disconnectedPromise = new DefaultPromise<Void>(GlobalEventExecutor.INSTANCE);
        this.closePromise = new DefaultPromise<Void>(GlobalEventExecutor.INSTANCE);
        this.isReconnecting = new AtomicBoolean(false);
        this.connectionListener = new ConnectionListener();
        this.increase();
    }

    protected abstract void initBootstrap() throws Exception;

    @Override
    protected void doClose() {
        if (this.isClosed()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection:{} freed", this);
            }
            this.performClose();
            this.closePromise.setSuccess(null);
        }
    }

    protected void performClose() {
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel current = this.getNettyChannel();
        if (current != null) {
            current.close();
        }
        this.clearNettyChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws RemotingException {
        if (!this.isReconnecting.compareAndSet(false, true)) {
            return;
        }
        if (this.isClosed()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection:{} aborted to reconnect cause connection closed", this);
            }
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connection:{} attempting to reconnect to server {}", this, this.getConnectAddress());
        }
        this.init.compareAndSet(false, true);
        long start = System.currentTimeMillis();
        Promise<Object> connectingPromise = this.getOrCreateConnectingPromise();
        ChannelFuture connectPromise = this.performConnect();
        connectPromise.addListener(this.connectionListener);
        boolean ret = connectingPromise.awaitUninterruptibly(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        AbstractNettyConnectionClient abstractNettyConnectionClient = this;
        synchronized (abstractNettyConnectionClient) {
            this.connectingPromiseRef.set(null);
        }
        if (connectPromise.cause() != null) {
            Throwable cause = connectPromise.cause();
            RemotingException remotingException = new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + ", error message is:" + cause.getMessage(), cause);
            this.logger.error("6-1", "network disconnected", "", "Failed to connect to provider server by other reason", cause);
            throw remotingException;
        }
        if (!ret || !connectPromise.isSuccess()) {
            RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            this.logger.error("6-2", "provider crash", "", "Client-side timeout", remotingException);
            throw remotingException;
        }
    }

    protected abstract ChannelFuture performConnect();

    @Override
    protected void doDisConnect() {
        NettyChannel.removeChannelIfDisconnected(this.getNettyChannel());
    }

    protected void doReconnect() {
        this.connectivityExecutor.execute(() -> {
            try {
                this.doConnect();
            }
            catch (RemotingException e) {
                this.logger.error("6-16", "", "", "Failed to reconnect to server: " + this.getConnectAddress());
            }
        });
    }

    @Override
    public void onConnected(Object channel) {
        if (!(channel instanceof org.apache.dubbo.netty.shaded.io.netty.channel.Channel)) {
            return;
        }
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel nettyChannel = (org.apache.dubbo.netty.shaded.io.netty.channel.Channel)channel;
        if (this.isClosed()) {
            nettyChannel.close();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection:{} is closed, ignoring connected event", this);
            }
            return;
        }
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel current = this.getNettyChannel();
        if (current != null) {
            current.close();
        }
        this.channelRef.set(nettyChannel);
        Promise<Object> connectingPromise = this.connectingPromiseRef.get();
        if (connectingPromise != null) {
            connectingPromise.trySuccess(CONNECTED_OBJECT);
        }
        nettyChannel.attr(CONNECTION).set(this);
        this.connectedPromise.trySuccess(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connection:{} connected", this);
        }
    }

    @Override
    public void onGoaway(Object channel) {
        if (!(channel instanceof org.apache.dubbo.netty.shaded.io.netty.channel.Channel)) {
            return;
        }
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel nettyChannel = (org.apache.dubbo.netty.shaded.io.netty.channel.Channel)channel;
        if (this.channelRef.compareAndSet(nettyChannel, null)) {
            if (nettyChannel.isOpen()) {
                nettyChannel.close();
            }
            NettyChannel.removeChannelIfDisconnected(nettyChannel);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection:{} goaway", this);
            }
        }
    }

    @Override
    protected Channel getChannel() {
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel c = this.getNettyChannel();
        if (c == null) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), this);
    }

    private org.apache.dubbo.netty.shaded.io.netty.channel.Channel getNettyChannel() {
        return this.channelRef.get();
    }

    protected void clearNettyChannel() {
        this.channelRef.set(null);
    }

    @Override
    public <T> T getChannel(Boolean generalizable) {
        return (T)(Boolean.TRUE.equals(generalizable) ? this.getNettyChannel() : this.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        if (this.isClosed()) {
            return false;
        }
        org.apache.dubbo.netty.shaded.io.netty.channel.Channel nettyChannel = this.getNettyChannel();
        if (nettyChannel != null && nettyChannel.isActive()) {
            return true;
        }
        if (this.init.compareAndSet(false, true)) {
            try {
                this.doConnect();
            }
            catch (RemotingException e) {
                this.logger.error("6-16", "", "", "Failed to connect to server: " + this.getConnectAddress());
            }
        }
        this.getOrCreateConnectingPromise().awaitUninterruptibly(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        AbstractNettyConnectionClient abstractNettyConnectionClient = this;
        synchronized (abstractNettyConnectionClient) {
            this.connectingPromiseRef.set(null);
        }
        nettyChannel = this.getNettyChannel();
        return nettyChannel != null && nettyChannel.isActive();
    }

    private Promise<Object> getOrCreateConnectingPromise() {
        this.connectingPromiseRef.compareAndSet(null, new DefaultPromise(GlobalEventExecutor.INSTANCE));
        return this.connectingPromiseRef.get();
    }

    public Promise<Void> getClosePromise() {
        return this.closePromise;
    }

    public static AbstractConnectionClient getConnectionClientFromChannel(org.apache.dubbo.netty.shaded.io.netty.channel.Channel channel) {
        return channel.attr(CONNECTION).get();
    }

    public ChannelFuture write(Object request) throws RemotingException {
        if (!this.isAvailable()) {
            throw new RemotingException(null, null, "Failed to send request " + request + ", cause: The channel to " + this.remote + " is closed!");
        }
        return this.getNettyChannel().writeAndFlush(request);
    }

    @Override
    public void addConnectedListener(Runnable func) {
        this.connectedPromise.addListener(future -> func.run());
    }

    @Override
    public void addDisconnectedListener(Runnable func) {
        this.disconnectedPromise.addListener(future -> func.run());
    }

    @Override
    public void addCloseListener(Runnable func) {
        this.closePromise.addListener(future -> func.run());
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public String toString() {
        return super.toString() + " (Ref=" + this.getCounter() + ",local=" + Optional.ofNullable(this.getChannel()).map(Endpoint::getLocalAddress).orElse(null) + ",remote=" + this.getRemoteAddress();
    }

    class ConnectionListener
    implements ChannelFutureListener {
        ConnectionListener() {
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            if (!AbstractNettyConnectionClient.this.isReconnecting.compareAndSet(true, false)) {
                return;
            }
            if (future.isSuccess()) {
                return;
            }
            AbstractNettyConnectionClient connectionClient = AbstractNettyConnectionClient.this;
            if (connectionClient.isClosed() || connectionClient.getCounter() == 0L) {
                if (AbstractNettyConnectionClient.this.logger.isDebugEnabled()) {
                    AbstractNettyConnectionClient.this.logger.debug("Connection:{} aborted to reconnect. {}", connectionClient, future.cause().getMessage());
                }
                return;
            }
            if (AbstractNettyConnectionClient.this.logger.isDebugEnabled()) {
                AbstractNettyConnectionClient.this.logger.debug("Connection:{} is reconnecting, attempt=0 cause={}", connectionClient, future.cause().getMessage());
            }
            AbstractNettyConnectionClient.this.disconnectedPromise.trySuccess(null);
            AbstractNettyConnectionClient.this.doReconnect();
        }
    }
}

