/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.netty.NettyChannel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

@ChannelHandler.Sharable
public class NettyHandler
extends SimpleChannelHandler {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyHandler.class);
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final URL url;
    private final ChannelHandler handler;

    public NettyHandler(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        org.jboss.netty.channel.Channel ch = ctx.getChannel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            if (channel != null) {
                this.channels.put(NetUtils.toAddressString((InetSocketAddress)ch.getRemoteAddress()), channel);
            }
            this.handler.connected(channel);
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ch);
        }
        if (logger.isInfoEnabled() && channel != null) {
            logger.info("The connection {} between {} and {} is established.", ch, channel.getRemoteAddress(), channel.getLocalAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        org.jboss.netty.channel.Channel ch = ctx.getChannel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            this.channels.remove(NetUtils.toAddressString((InetSocketAddress)ch.getRemoteAddress()));
            this.handler.disconnected(channel);
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ch);
        }
        if (logger.isInfoEnabled()) {
            logger.info("The connection {} between {} and {} is disconnected.", ch, channel.getRemoteAddress(), channel.getLocalAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.getChannel(), this.url, this.handler);
        try {
            this.handler.received(channel, e.getMessage());
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ctx.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.writeRequested(ctx, e);
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.getChannel(), this.url, this.handler);
        try {
            this.handler.sent(channel, e.getMessage());
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ctx.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        org.jboss.netty.channel.Channel ch = ctx.getChannel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            this.handler.caught(channel, e.getCause());
        }
        finally {
            NettyChannel.removeChannelIfDisconnected(ch);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("6-4", "", "", channel == null ? String.format("The connection %s has exception.", ch) : String.format("The connection %s between %s and %s has exception.", ch, channel.getRemoteAddress(), channel.getLocalAddress()), e.getCause());
        }
    }
}

