/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufOutputStream;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpChannelFutureListener;

public class NettyHttp3StreamChannel
implements H2StreamChannel {
    private final QuicStreamChannel http3StreamChannel;

    public NettyHttp3StreamChannel(QuicStreamChannel http3StreamChannel) {
        this.http3StreamChannel = http3StreamChannel;
    }

    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.close().addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public Http2OutputMessage newOutputMessage(boolean endStream) {
        ByteBuf buffer = this.http3StreamChannel.alloc().buffer();
        return new Http2OutputMessageFrame(new ByteBufOutputStream(buffer), endStream);
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.write((Object)httpMetadata).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.write((Object)httpOutputMessage).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.http3StreamChannel.parent().remoteSocketAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.http3StreamChannel.parent().localSocketAddress();
    }

    @Override
    public void flush() {
        this.http3StreamChannel.flush();
    }
}

