/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import java.io.OutputStream;
import java.net.SocketAddress;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufOutputStream;
import org.apache.dubbo.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.Headers;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.DefaultHttp3DataFrame;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.DefaultHttp3Headers;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.DefaultHttp3HeadersFrame;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3DataFrame;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3Headers;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3HeadersFrame;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3RequestStreamInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.message.DefaultHttpHeaders;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.remoting.http3.netty4.Constants;

@ChannelHandler.Sharable
public class NettyHttp3FrameCodec
extends Http3RequestStreamInboundHandler
implements ChannelOutboundHandler {
    public static final NettyHttp3FrameCodec INSTANCE = new NettyHttp3FrameCodec();

    protected void channelRead(ChannelHandlerContext ctx, Http3HeadersFrame frame) {
        Http3Headers headers = frame.headers();
        if (headers.contains((Object)Constants.TRI_PING)) {
            this.pingReceived(ctx);
            return;
        }
        ctx.fireChannelRead(new Http2MetadataFrame(NettyHttp3FrameCodec.getStreamId(ctx), new DefaultHttpHeaders((Headers<CharSequence, CharSequence, ?>)headers), false));
    }

    private void pingReceived(ChannelHandlerContext ctx) {
        DefaultHttp3Headers pongHeader = new DefaultHttp3Headers(false);
        pongHeader.set((Object)Constants.TRI_PING, (Object)"0");
        pongHeader.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)HttpStatus.OK.getStatusString());
        ctx.write(new DefaultHttp3HeadersFrame((Http3Headers)pongHeader));
        ctx.close();
    }

    protected void channelRead(ChannelHandlerContext ctx, Http3DataFrame frame) {
        ctx.fireChannelRead(new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), new ByteBufInputStream(frame.content(), true), false));
    }

    private static long getStreamId(ChannelHandlerContext ctx) {
        return ((QuicStreamChannel)ctx.channel()).streamId();
    }

    protected void channelInputClosed(ChannelHandlerContext ctx) {
        ctx.fireChannelRead(new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), StreamUtils.EMPTY, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2Header) {
            Http2Header headers = (Http2Header)msg;
            ctx.write(new DefaultHttp3HeadersFrame((Http3Headers)((NettyHttpHeaders)headers.headers()).getHeaders()), promise);
            if (headers.isEndStream()) {
                ctx.close();
            }
        } else {
            if (msg instanceof Http2OutputMessage) {
                Http2OutputMessage message = (Http2OutputMessage)msg;
                try {
                    OutputStream body = message.getBody();
                    if (body == null) {
                        DefaultHttp3DataFrame frame = new DefaultHttp3DataFrame(Unpooled.EMPTY_BUFFER);
                        ctx.write(frame, promise);
                        return;
                    }
                    if (body instanceof ByteBufOutputStream) {
                        DefaultHttp3DataFrame frame = new DefaultHttp3DataFrame(((ByteBufOutputStream)body).buffer());
                        ctx.write(frame, promise);
                        return;
                    }
                }
                finally {
                    if (message.isEndStream()) {
                        ctx.close();
                    }
                }
                throw new IllegalArgumentException("Http2OutputMessage body must be ByteBufOutputStream");
            }
            ctx.write(msg, promise);
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }
}

