/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import java.net.InetSocketAddress;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannel;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.remoting.transport.netty4.ChannelAddressAccessor;

@Activate(order=-100, onClass={"org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannel"})
public class Http3ChannelAddressAccessor
implements ChannelAddressAccessor {
    @Override
    public String getProtocol() {
        return "UDP";
    }

    @Override
    public InetSocketAddress getRemoteAddress(Channel channel) {
        if (channel instanceof QuicStreamChannel) {
            return (InetSocketAddress)((QuicStreamChannel)channel).parent().remoteSocketAddress();
        }
        if (channel instanceof QuicChannel) {
            return (InetSocketAddress)((QuicChannel)channel).remoteSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getLocalAddress(Channel channel) {
        if (channel instanceof QuicStreamChannel) {
            return (InetSocketAddress)((QuicStreamChannel)channel).parent().localSocketAddress();
        }
        if (channel instanceof QuicChannel) {
            return (InetSocketAddress)((QuicChannel)channel).localSocketAddress();
        }
        return null;
    }
}

