/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3;

import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.ssl.AuthPolicy;
import org.apache.dubbo.common.ssl.Cert;
import org.apache.dubbo.common.ssl.CertManager;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.ClientAuth;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.SslContext;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.dubbo.netty.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.http3.Http3;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicSslContext;
import org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicSslContextBuilder;

public final class Http3SslContexts
extends SslContext {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(Http3SslContexts.class);

    private Http3SslContexts() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QuicSslContext buildServerSslContext(URL url) {
        QuicSslContextBuilder builder;
        CertManager certManager = Http3SslContexts.getCertManager(url);
        ProviderCert cert = certManager.getProviderConnectionConfig(url, url.toInetSocketAddress());
        if (cert == null) {
            return Http3SslContexts.buildSelfSignedServerSslContext(url);
        }
        try (InputStream privateKeyIn = cert.getPrivateKeyInputStream();
             InputStream keyCertChainIn = cert.getKeyCertChainInputStream();){
            if (keyCertChainIn == null || privateKeyIn == null) {
                QuicSslContext quicSslContext = Http3SslContexts.buildSelfSignedServerSslContext(url);
                return quicSslContext;
            }
            builder = QuicSslContextBuilder.forServer((PrivateKey)Http3SslContexts.toPrivateKey(privateKeyIn, cert.getPassword()), (String)cert.getPassword(), (X509Certificate[])Http3SslContexts.toX509Certificates(keyCertChainIn));
            try (InputStream trustCertIn = cert.getTrustCertInputStream();){
                if (trustCertIn != null) {
                    ClientAuth clientAuth = cert.getAuthPolicy() == AuthPolicy.CLIENT_AUTH ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
                    builder.trustManager(Http3SslContexts.toX509Certificates(trustCertIn)).clientAuth(clientAuth);
                }
            }
        }
        catch (IllegalStateException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", t);
        }
        try {
            return builder.applicationProtocols(Http3.supportedApplicationProtocols()).build();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Build SslSession failed.", t);
        }
    }

    private static QuicSslContext buildSelfSignedServerSslContext(URL url) {
        SelfSignedCertificate certificate;
        LOGGER.info("Provider cert not configured, build self signed sslContext, url=[{}]", url.toString(""));
        try {
            certificate = new SelfSignedCertificate();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to create self signed certificate, Please import bcpkix jar", e);
        }
        return QuicSslContextBuilder.forServer((File)certificate.privateKey(), null, (File)certificate.certificate()).applicationProtocols(Http3.supportedApplicationProtocols()).build();
    }

    public static QuicSslContext buildClientSslContext(URL url) {
        QuicSslContextBuilder builder;
        block24: {
            CertManager certManager = Http3SslContexts.getCertManager(url);
            Cert cert = certManager.getConsumerConnectionConfig(url);
            builder = QuicSslContextBuilder.forClient();
            try {
                if (cert == null) {
                    LOGGER.info("Consumer cert not configured, build insecure sslContext, url=[{}]", url.toString(""));
                    builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                    break block24;
                }
                try (InputStream trustCertIn = cert.getTrustCertInputStream();
                     InputStream privateKeyIn = cert.getPrivateKeyInputStream();
                     InputStream keyCertChainIn = cert.getKeyCertChainInputStream();){
                    if (trustCertIn != null) {
                        builder.trustManager(Http3SslContexts.toX509Certificates(trustCertIn));
                    }
                    builder.keyManager(Http3SslContexts.toPrivateKey(privateKeyIn, cert.getPassword()), cert.getPassword(), Http3SslContexts.toX509Certificates(keyCertChainIn));
                }
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", t);
            }
        }
        try {
            return builder.applicationProtocols(Http3.supportedApplicationProtocols()).build();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Build SslSession failed.", t);
        }
    }

    private static CertManager getCertManager(URL url) {
        return url.getOrDefaultFrameworkModel().getBeanFactory().getBean(CertManager.class);
    }

    @Override
    public boolean isClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> cipherSuites() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLEngine newEngine(ByteBufAllocator alloc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLSessionContext sessionContext() {
        throw new UnsupportedOperationException();
    }
}

