/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h1;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.message.HttpHeadersMapAdapter;
import org.apache.dubbo.remoting.http12.netty4.StringValueIterator;

public final class NettyHttp1HttpHeaders
implements HttpHeaders {
    private final org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaders headers;

    public NettyHttp1HttpHeaders(org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaders headers) {
        this.headers = headers;
    }

    public NettyHttp1HttpHeaders() {
        this(new DefaultHttpHeaders(false));
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(CharSequence key) {
        return this.headers.contains(key);
    }

    @Override
    public String getFirst(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> get(CharSequence key) {
        return this.headers.getAll(key);
    }

    @Override
    public HttpHeaders add(CharSequence name, String value) {
        this.headers.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<String> values) {
        this.headers.add(name, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, String ... values) {
        this.headers.add(name, Arrays.asList(values));
        return this;
    }

    @Override
    public HttpHeaders add(Map<? extends CharSequence, ? extends Iterable<String>> map) {
        for (Map.Entry<? extends CharSequence, ? extends Iterable<String>> entry : map.entrySet()) {
            this.headers.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        for (Map.Entry<CharSequence, String> entry : headers) {
            this.headers.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, String value) {
        this.headers.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<String> values) {
        this.headers.set(name, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, String ... values) {
        this.headers.set(name, Arrays.asList(values));
        return this;
    }

    @Override
    public HttpHeaders set(Map<? extends CharSequence, ? extends Iterable<String>> map) {
        for (Map.Entry<? extends CharSequence, ? extends Iterable<String>> entry : map.entrySet()) {
            this.headers.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HttpHeaders set(HttpHeaders headers) {
        for (Map.Entry<CharSequence, String> entry : headers) {
            this.headers.set(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public List<String> remove(CharSequence key) {
        List<String> all = this.headers.getAll(key);
        this.headers.remove(key);
        return all;
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> names() {
        return this.headers.names();
    }

    @Override
    public Set<CharSequence> nameSet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> names = new LinkedHashSet<CharSequence>(this.headers.size());
        for (Map.Entry<CharSequence, String> entry : this) {
            names.add(entry.getKey());
        }
        return names;
    }

    @Override
    public Map<String, List<String>> asMap() {
        return this.headers.isEmpty() ? Collections.emptyMap() : new HttpHeadersMapAdapter(this);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, String>> iterator() {
        return new StringValueIterator(this.headers.iteratorCharSequence());
    }

    public DefaultHttpHeaders getHeaders() {
        return (DefaultHttpHeaders)this.headers;
    }

    public boolean equals(Object obj) {
        return obj instanceof NettyHttp1HttpHeaders && this.headers.equals(((NettyHttp1HttpHeaders)obj).headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return "NettyHttp1HttpHeaders{headers=" + this.headers + '}';
    }
}

