/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h1;

import java.io.OutputStream;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufOutputStream;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.DefaultHttp1Request;
import org.apache.dubbo.remoting.http12.h1.Http1InputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1RequestMetadata;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1HttpHeaders;

public class NettyHttp1Codec
extends ChannelDuplexHandler {
    private boolean keepAlive;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            this.keepAlive = HttpUtil.isKeepAlive(request);
            super.channelRead(ctx, new DefaultHttp1Request(new Http1RequestMetadata(new NettyHttp1HttpHeaders(request.headers()), request.method().name(), request.uri()), new Http1InputMessage(new ByteBufInputStream(request.content(), true))));
            return;
        }
        super.channelRead(ctx, msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpMetadata) {
            this.doWriteHeader(ctx, (HttpMetadata)msg, promise);
            return;
        }
        if (msg instanceof HttpOutputMessage) {
            this.doWriteMessage(ctx, (HttpOutputMessage)msg, promise);
            return;
        }
        super.write(ctx, msg, promise);
    }

    private void doWriteHeader(ChannelHandlerContext ctx, HttpMetadata msg, ChannelPromise promise) {
        NettyHttp1HttpHeaders headers = (NettyHttp1HttpHeaders)msg.headers();
        List<String> statusHeaders = headers.remove(HttpHeaderNames.STATUS.getKey());
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (CollectionUtils.isNotEmpty(statusHeaders)) {
            status = HttpResponseStatus.valueOf(Integer.parseInt(statusHeaders.get(0)));
        }
        if (this.keepAlive) {
            headers.add(HttpHeaderNames.CONNECTION.getKey(), String.valueOf(HttpHeaderValues.KEEP_ALIVE));
        } else {
            headers.add(HttpHeaderNames.CONNECTION.getKey(), String.valueOf(HttpHeaderValues.CLOSE));
        }
        ctx.writeAndFlush(new DefaultHttpResponse(HttpVersion.HTTP_1_1, status, headers.getHeaders()), promise);
    }

    private void doWriteMessage(ChannelHandlerContext ctx, HttpOutputMessage msg, ChannelPromise promise) {
        if (HttpOutputMessage.EMPTY_MESSAGE == msg) {
            if (this.keepAlive) {
                ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, promise);
            } else {
                ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            return;
        }
        OutputStream body = msg.getBody();
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            ctx.writeAndFlush(buffer, promise);
            return;
        }
        throw new IllegalArgumentException("HttpOutputMessage body must be 'io.netty.buffer.ByteBufOutputStream'");
    }
}

