/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpJsonUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class HtmlCodec
implements HttpMessageCodec {
    public static final HtmlCodec INSTANCE = new HtmlCodec();
    private final HttpJsonUtils httpJsonUtils;

    private HtmlCodec() {
        this(FrameworkModel.defaultModel());
    }

    public HtmlCodec(FrameworkModel frameworkModel) {
        this.httpJsonUtils = frameworkModel.getBeanFactory().getOrRegisterBean(HttpJsonUtils.class);
    }

    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        if (data == null) {
            return;
        }
        try {
            if (data instanceof CharSequence) {
                os.write(data.toString().getBytes(charset));
                return;
            }
            os.write(this.httpJsonUtils.toJson(data).getBytes(charset));
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding html", t);
        }
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            if (targetType == String.class) {
                return StreamUtils.toString(is, charset);
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error decoding html", t);
        }
        throw new DecodeException("'text/html' media-type only supports String as method param.");
    }

    @Override
    public MediaType mediaType() {
        return MediaType.TEXT_HTML;
    }
}

