/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoderFactory;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoderFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class CodecUtils {
    private final FrameworkModel frameworkModel;
    private final List<HttpMessageDecoderFactory> decoderFactories;
    private final List<HttpMessageEncoderFactory> encoderFactories;
    private final Map<String, Optional<HttpMessageEncoderFactory>> encoderCache = new ConcurrentHashMap<String, Optional<HttpMessageEncoderFactory>>();
    private final Map<String, Optional<HttpMessageDecoderFactory>> decoderCache = new ConcurrentHashMap<String, Optional<HttpMessageDecoderFactory>>();
    private Set<String> disallowedContentTypes = Collections.emptySet();

    public CodecUtils(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.decoderFactories = frameworkModel.getActivateExtensions(HttpMessageDecoderFactory.class);
        this.encoderFactories = frameworkModel.getActivateExtensions(HttpMessageEncoderFactory.class);
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration(frameworkModel.defaultApplication());
        String contentTypes = configuration.getString("dubbo.protocol.triple.rest.disallowed-content-types", null);
        if (contentTypes != null) {
            this.disallowedContentTypes = new HashSet<String>(StringUtils.tokenizeToList(contentTypes, new char[0]));
        }
    }

    public HttpMessageDecoder determineHttpMessageDecoder(URL url, String mediaType) {
        return this.determineHttpMessageDecoderFactory(mediaType).orElseThrow(() -> new UnsupportedMediaTypeException(mediaType)).createCodec(url, this.frameworkModel, mediaType);
    }

    public HttpMessageDecoder determineHttpMessageDecoder(String mediaType) {
        return this.determineHttpMessageDecoder(null, mediaType);
    }

    public HttpMessageEncoder determineHttpMessageEncoder(URL url, String mediaType) {
        return this.determineHttpMessageEncoderFactory(mediaType).orElseThrow(() -> new UnsupportedMediaTypeException(mediaType)).createCodec(url, this.frameworkModel, mediaType);
    }

    public HttpMessageEncoder determineHttpMessageEncoder(String mediaType) {
        return this.determineHttpMessageEncoder(null, mediaType);
    }

    public Optional<HttpMessageDecoderFactory> determineHttpMessageDecoderFactory(String mediaType) {
        Assert.notNull((Object)mediaType, "mediaType must not be null");
        return this.decoderCache.computeIfAbsent(mediaType, k -> {
            for (HttpMessageDecoderFactory factory : this.decoderFactories) {
                if (!factory.supports((String)k) || this.disallowedContentTypes.contains(factory.mediaType().getName())) continue;
                return Optional.of(factory);
            }
            return Optional.empty();
        });
    }

    public Optional<HttpMessageEncoderFactory> determineHttpMessageEncoderFactory(String mediaType) {
        Assert.notNull((Object)mediaType, "mediaType must not be null");
        return this.encoderCache.computeIfAbsent(mediaType, k -> {
            for (HttpMessageEncoderFactory factory : this.encoderFactories) {
                if (!factory.supports((String)k) || this.disallowedContentTypes.contains(factory.mediaType().getName())) continue;
                return Optional.of(factory);
            }
            return Optional.empty();
        });
    }

    public List<HttpMessageDecoderFactory> getDecoderFactories() {
        return this.decoderFactories;
    }

    public List<HttpMessageEncoderFactory> getEncoderFactories() {
        return this.encoderFactories;
    }
}

