/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.ServerSentEvent;

public final class ServerSentEventEncoder
implements HttpMessageEncoder {
    private final HttpMessageEncoder httpMessageEncoder;

    public ServerSentEventEncoder(HttpMessageEncoder httpMessageEncoder) {
        this.httpMessageEncoder = httpMessageEncoder;
    }

    @Override
    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        StringBuilder sb = new StringBuilder(256);
        if (data instanceof ServerSentEvent) {
            ServerSentEvent event = (ServerSentEvent)data;
            if (event.getId() != null) {
                ServerSentEventEncoder.appendField(sb, "id", event.getId());
            }
            if (event.getEvent() != null) {
                ServerSentEventEncoder.appendField(sb, "event", event.getEvent());
            }
            if (event.getRetry() != null) {
                ServerSentEventEncoder.appendField(sb, "retry", event.getRetry().toMillis());
            }
            if (event.getComment() != null) {
                sb.append(':').append(StringUtils.replace(event.getComment(), "\n", "\n:")).append('\n');
            }
            if (event.getData() != null) {
                this.encodeData(sb, event.getData(), charset);
            }
        } else {
            this.encodeData(sb, data, charset);
        }
        sb.append('\n');
        try {
            outputStream.write(sb.toString().getBytes(charset));
        }
        catch (Exception e) {
            throw new EncodeException("Error encoding ServerSentEvent", (Throwable)e);
        }
    }

    private void encodeData(StringBuilder sb, Object data, Charset charset) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        this.httpMessageEncoder.encode((OutputStream)bos, data, charset);
        String dataStr = new String(bos.toByteArray(), charset);
        List<String> lines = StringUtils.splitToList(dataStr, '\n');
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            ServerSentEventEncoder.appendField(sb, "data", lines.get(i));
        }
    }

    private static void appendField(StringBuilder sb, String name, Object value) {
        sb.append(name).append(':').append(value).append('\n');
    }

    @Override
    public String contentType() {
        return this.httpMessageEncoder.contentType();
    }

    @Override
    public MediaType mediaType() {
        return this.httpMessageEncoder.mediaType();
    }

    @Override
    public boolean supports(String mediaType) {
        return this.httpMessageEncoder.supports(mediaType);
    }
}

