/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.time.Duration;

public final class ServerSentEvent<T> {
    private final String id;
    private final String event;
    private final Duration retry;
    private final String comment;
    private final T data;

    public ServerSentEvent(String id, String event, Duration retry, String comment, T data) {
        this.id = id;
        this.event = event;
        this.retry = retry;
        this.comment = comment;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public Duration getRetry() {
        return this.retry;
    }

    public String getComment() {
        return this.comment;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "ServerSentEvent{id='" + this.id + '\'' + ", event='" + this.event + '\'' + ", retry=" + this.retry + ", comment='" + this.comment + '\'' + ", data=" + this.data + '}';
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private String id;
        private String event;
        private Duration retry;
        private String comment;
        private T data;

        private Builder() {
        }

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> event(String event) {
            this.event = event;
            return this;
        }

        public Builder<T> retry(Duration retry) {
            this.retry = retry;
            return this;
        }

        public Builder<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ServerSentEvent<T> build() {
            return new ServerSentEvent<T>(this.id, this.event, this.retry, this.comment, this.data);
        }
    }
}

