/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.util.Objects;

public final class MediaType {
    public static final String WILDCARD = "*";
    public static final String APPLICATION = "application";
    public static final String TEXT = "text";
    public static final String JSON = "json";
    public static final String XML = "xml";
    public static final String YAML = "yaml";
    public static final MediaType ALL = new MediaType("*", "*");
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_YAML = new MediaType("application", "yaml");
    public static final MediaType APPLICATION_JAVASCRIPT = new MediaType("application", "javascript");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final MediaType APPLICATION_GRPC = new MediaType("application", "grpc");
    public static final MediaType APPLICATION_GRPC_PROTO = new MediaType("application", "grpc+proto");
    public static final MediaType APPLICATION_FROM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
    public static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    public static final MediaType TEXT_JSON = new MediaType("text", "json");
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    public static final MediaType TEXT_YAML = new MediaType("text", "yaml");
    public static final MediaType TEXT_CSS = new MediaType("text", "css");
    public static final MediaType TEXT_JAVASCRIPT = new MediaType("text", "javascript");
    public static final MediaType TEXT_HTML = new MediaType("text", "html");
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    public static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    private final String name;
    private final String type;
    private final String subType;

    public MediaType(String type, String subType) {
        this.type = type;
        this.subType = subType;
        this.name = type + '/' + subType;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean isPureText() {
        return TEXT.equals(this.type);
    }

    public static MediaType of(String name) {
        Objects.requireNonNull(name);
        if (MediaType.APPLICATION_JSON.name.equals(name)) {
            return APPLICATION_JSON;
        }
        if (MediaType.APPLICATION_YAML.name.equals(name)) {
            return APPLICATION_YAML;
        }
        if (MediaType.APPLICATION_FROM_URLENCODED.name.equals(name)) {
            return APPLICATION_FROM_URLENCODED;
        }
        int index = name.indexOf(47);
        if (index > 0) {
            return new MediaType(name.substring(0, index), name.substring(index + 1));
        }
        throw new IllegalArgumentException("Invalid media type: '" + name + "'");
    }
}

