/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h2;

import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.Http2Header;

public final class Http2MetadataFrame
implements Http2Header {
    private final long streamId;
    private final HttpHeaders headers;
    private final boolean endStream;

    public Http2MetadataFrame(HttpHeaders headers) {
        this(-1L, headers, false);
    }

    public Http2MetadataFrame(HttpHeaders headers, boolean endStream) {
        this(-1L, headers, endStream);
    }

    public Http2MetadataFrame(long streamId, HttpHeaders headers, boolean endStream) {
        this.streamId = streamId;
        this.headers = headers;
        this.endStream = endStream;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public String method() {
        return this.headers.getFirst(Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public String path() {
        return this.headers.getFirst(Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public long id() {
        return this.streamId;
    }

    @Override
    public boolean isEndStream() {
        return this.endStream;
    }

    public String toString() {
        return "Http2MetadataFrame{method='" + this.method() + '\'' + ", path='" + this.path() + '\'' + ", contentType='" + this.contentType() + "', streamId=" + this.streamId + ", endStream=" + this.endStream + '}';
    }
}

