/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.connection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.api.connection.ConnectionManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class SingleProtocolConnectionManager
implements ConnectionManager {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SingleProtocolConnectionManager.class);
    public static final String NAME = "single";
    private final ConcurrentMap<String, AbstractConnectionClient> connections = new ConcurrentHashMap<String, AbstractConnectionClient>(16);
    private FrameworkModel frameworkModel;

    public SingleProtocolConnectionManager(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public AbstractConnectionClient connect(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        return this.connections.compute(url.getAddress(), (address, conn) -> {
            String transport = url.getParameter("transporter", "netty4");
            if (conn == null) {
                return this.createAbstractConnectionClient(url, handler, (String)address, transport);
            }
            boolean shouldReuse = conn.retain();
            if (!shouldReuse) {
                logger.info("Trying to create a new connection for {}.", address);
                return this.createAbstractConnectionClient(url, handler, (String)address, transport);
            }
            return conn;
        });
    }

    private AbstractConnectionClient createAbstractConnectionClient(URL url, ChannelHandler handler, String address, String transport) {
        ConnectionManager manager = this.frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension(transport);
        AbstractConnectionClient connectionClient = manager.connect(url, handler);
        connectionClient.addCloseListener(() -> {
            logger.info("Remove closed connection (with reference count==0) for address {}, a new one will be created for upcoming RPC requests routing to this address.", address);
            this.connections.remove(address, connectionClient);
        });
        return connectionClient;
    }

    @Override
    public void forEachConnection(Consumer<AbstractConnectionClient> connectionConsumer) {
        this.connections.values().forEach(connectionConsumer);
    }
}

