/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.connection;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractClient;

public abstract class AbstractConnectionClient
extends AbstractClient {
    protected WireProtocol protocol;
    protected InetSocketAddress remote;
    protected AtomicBoolean init;
    protected static final Object CONNECTED_OBJECT = new Object();
    private volatile long counter;
    private static final AtomicLongFieldUpdater<AbstractConnectionClient> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractConnectionClient.class, "counter");

    protected AbstractConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected AbstractConnectionClient() {
    }

    public final void increase() {
        COUNTER_UPDATER.set(this, 1L);
    }

    public final boolean retain() {
        long oldCount = COUNTER_UPDATER.getAndIncrement(this);
        if (oldCount <= 0L) {
            COUNTER_UPDATER.getAndDecrement(this);
            this.logger.info("Retain failed, because connection " + this.remote + " has been destroyed but not yet removed, will create a new one instead. Check logs below to confirm that this connection finally gets removed to make sure there's no potential memory leak!");
            return false;
        }
        return true;
    }

    public boolean release() {
        long remainingCount = COUNTER_UPDATER.decrementAndGet(this);
        if (remainingCount == 0L) {
            this.logger.info("Destroying connection to {}, because the reference count reaches 0", this.remote);
            this.destroy();
            return true;
        }
        if (remainingCount <= -1L) {
            this.logger.warn("4-7", "", "", "This instance has been destroyed");
            return false;
        }
        return false;
    }

    protected abstract void initConnectionClient();

    public abstract boolean isAvailable();

    public abstract void addConnectedListener(Runnable var1);

    public abstract void addDisconnectedListener(Runnable var1);

    public abstract void addCloseListener(Runnable var1);

    public abstract void onConnected(Object var1);

    public abstract void onGoaway(Object var1);

    public abstract void destroy();

    public abstract <T> T getChannel(Boolean var1);

    public long getCounter() {
        return COUNTER_UPDATER.get(this);
    }
}

