/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.RegistryNotifier;
import org.apache.dubbo.registry.nacos.NacosAggregateListener;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosServiceName;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.registry.support.SkipFailbackWrapperException;
import org.apache.dubbo.rpc.RpcException;

public class NacosRegistry
extends FailbackRegistry {
    private static final List<String> ALL_SUPPORTED_CATEGORIES = Arrays.asList("providers", "consumers", "routers", "configurators");
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private static final String WILDCARD = "*";
    private static final String UP = "UP";
    private static final String SERVICE_NAME_SEPARATOR = SystemPropertyConfigUtils.getSystemProperty("nacos.service.name.separator", ":");
    private static final int PAGINATION_SIZE = Integer.getInteger("nacos.service.names.pagination.size", 100);
    private static final long LOOKUP_INTERVAL = Long.getLong("nacos.service.names.lookup.interval", 30L);
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NacosRegistry.class);
    private final NacosNamingServiceWrapper namingService;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private final Map<URL, Map<NotifyListener, NacosAggregateListener>> originToAggregateListener = new ConcurrentHashMap<URL, Map<NotifyListener, NacosAggregateListener>>();
    private final Map<URL, Map<NacosAggregateListener, Map<String, EventListener>>> nacosListeners = new ConcurrentHashMap<URL, Map<NacosAggregateListener, Map<String, EventListener>>>();
    private final boolean supportLegacyServiceName;

    public NacosRegistry(URL url, NacosNamingServiceWrapper namingService) {
        super(url);
        this.namingService = namingService;
        this.supportLegacyServiceName = url.getParameter("nacos.subscribe.legacy-name", false);
    }

    @Override
    public boolean isAvailable() {
        return UP.equals(this.namingService.getServerStatus());
    }

    @Override
    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            Set<String> serviceNames = this.getServiceNames(url, null);
            for (String serviceName : serviceNames) {
                List<Instance> instances = this.namingService.getAllInstancesWithoutSubscription(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"));
                urls.addAll(this.buildURLs(url, instances));
            }
            return urls;
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Exception cause) {
            throw new RpcException("Failed to lookup " + url + " from nacos " + this.getUrl() + ", cause: " + cause.getMessage(), (Throwable)cause);
        }
    }

    @Override
    public void doRegister(URL url) {
        try {
            if ("provider".equals(url.getSide()) || this.getUrl().getParameter("register-consumer-url", false)) {
                Instance instance = this.createInstance(url);
                HashSet<String> serviceNames = new HashSet<String>();
                String serviceName = this.getServiceName(url, false);
                serviceNames.add(serviceName);
                if (this.getUrl().getParameter("nacos.register-compatible", false)) {
                    String compatibleServiceName = this.getServiceName(url, true);
                    serviceNames.add(compatibleServiceName);
                }
                for (String service : serviceNames) {
                    this.namingService.registerInstance(service, this.getUrl().getGroup("DEFAULT_GROUP"), instance);
                }
            } else {
                logger.info("Please set 'dubbo.registry.parameters.register-consumer-url=true' to turn on consumer url registration.");
            }
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Exception cause) {
            throw new RpcException("Failed to register " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), (Throwable)cause);
        }
    }

    @Override
    public void doUnregister(URL url) {
        try {
            Instance instance = this.createInstance(url);
            HashSet<String> serviceNames = new HashSet<String>();
            String serviceName = this.getServiceName(url, false);
            serviceNames.add(serviceName);
            if (this.getUrl().getParameter("nacos.register-compatible", false)) {
                String serviceName1 = this.getServiceName(url, true);
                serviceNames.add(serviceName1);
            }
            for (String service : serviceNames) {
                this.namingService.deregisterInstance(service, this.getUrl().getGroup("DEFAULT_GROUP"), instance.getIp(), instance.getPort());
            }
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Exception cause) {
            throw new RpcException("Failed to unregister " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), (Throwable)cause);
        }
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        NacosAggregateListener nacosAggregateListener = new NacosAggregateListener(listener);
        this.originToAggregateListener.computeIfAbsent(url, k -> new ConcurrentHashMap()).put(listener, nacosAggregateListener);
        Set<String> serviceNames = this.getServiceNames(url, nacosAggregateListener);
        this.doSubscribe(url, nacosAggregateListener, serviceNames);
    }

    private void doSubscribe(URL url, NacosAggregateListener listener, Set<String> serviceNames) {
        try {
            if (this.isServiceNamesWithCompatibleMode(url)) {
                for (String serviceName : serviceNames) {
                    List<Instance> instances = this.namingService.getAllInstancesWithoutSubscription(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"));
                    this.notifySubscriber(url, serviceName, listener, instances);
                }
                for (String serviceName : serviceNames) {
                    this.subscribeEventListener(serviceName, url, listener);
                }
            } else {
                for (String serviceName : serviceNames) {
                    LinkedList<Instance> instances = new LinkedList<Instance>();
                    instances.addAll(this.namingService.getAllInstancesWithoutSubscription(serviceName, this.getUrl().getGroup("DEFAULT_GROUP")));
                    String serviceInterface = serviceName;
                    String[] segments = serviceName.split(SERVICE_NAME_SEPARATOR, -1);
                    if (segments.length == 4) {
                        serviceInterface = segments[1];
                    }
                    URL subscriberURL = url.setPath(serviceInterface).addParameters("interface", serviceInterface, "check", String.valueOf(false));
                    this.notifySubscriber(subscriberURL, serviceName, listener, instances);
                    this.subscribeEventListener(serviceName, subscriberURL, listener);
                }
            }
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to subscribe " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    private boolean isServiceNamesWithCompatibleMode(URL url) {
        return !this.isAdminProtocol(url) && this.createServiceName(url).isConcrete();
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.shutdownServiceNamesLookup();
        } else {
            Map<NotifyListener, NacosAggregateListener> listenerMap = this.originToAggregateListener.get(url);
            if (listenerMap == null) {
                logger.warn("1-37", "", "", String.format("No aggregate listener found for url %s, this service might have already been unsubscribed.", url));
                return;
            }
            NacosAggregateListener nacosAggregateListener = listenerMap.remove(listener);
            if (nacosAggregateListener != null) {
                Set<String> serviceNames = nacosAggregateListener.getServiceNames();
                try {
                    this.doUnsubscribe(url, nacosAggregateListener, serviceNames);
                }
                catch (NacosException e) {
                    logger.error("1-37", "", "", "Failed to unsubscribe " + url + " to nacos " + this.getUrl() + ", cause: " + e.getMessage(), e);
                }
            }
            if (listenerMap.isEmpty()) {
                this.originToAggregateListener.remove(url);
            }
        }
    }

    private void doUnsubscribe(URL url, NacosAggregateListener nacosAggregateListener, Set<String> serviceNames) throws NacosException {
        for (String serviceName : serviceNames) {
            this.unsubscribeEventListener(serviceName, url, nacosAggregateListener);
        }
    }

    private void shutdownServiceNamesLookup() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private Set<String> getServiceNames(URL url, NacosAggregateListener listener) {
        if (this.isAdminProtocol(url)) {
            this.scheduleServiceNamesLookup(url, listener);
            return this.getServiceNamesForOps(url);
        }
        return this.getServiceNames0(url);
    }

    private Set<String> getServiceNames0(URL url) {
        LinkedHashSet<String> serviceNames;
        NacosServiceName serviceName = this.createServiceName(url);
        if (serviceName.isConcrete()) {
            serviceNames = new LinkedHashSet();
            serviceNames.add(serviceName.toString());
            if (this.supportLegacyServiceName) {
                String legacySubscribedServiceName = this.getLegacySubscribedServiceName(url);
                if (!serviceName.toString().equals(legacySubscribedServiceName)) {
                    serviceNames.add(legacySubscribedServiceName);
                }
            }
        } else {
            serviceNames = this.filterServiceNames(serviceName);
        }
        return serviceNames;
    }

    private Set<String> filterServiceNames(NacosServiceName serviceName) {
        try {
            LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
            serviceNames.addAll(this.namingService.getServicesOfServer(1, Integer.MAX_VALUE, this.getUrl().getGroup("DEFAULT_GROUP")).getData().stream().filter(this::isConformRules).map(NacosServiceName::new).filter(serviceName::isCompatible).map(NacosServiceName::toString).collect(Collectors.toList()));
            return serviceNames;
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to filter serviceName from nacos, url: " + this.getUrl() + ", serviceName: " + serviceName + ", cause: " + cause.getMessage(), cause);
        }
    }

    private boolean isConformRules(String serviceName) {
        return serviceName.split(":", -1).length == 4;
    }

    private String getLegacySubscribedServiceName(URL url) {
        StringBuilder serviceNameBuilder = new StringBuilder("providers");
        this.appendIfPresent(serviceNameBuilder, url, "interface");
        this.appendIfPresent(serviceNameBuilder, url, "version");
        this.appendIfPresent(serviceNameBuilder, url, "group");
        return serviceNameBuilder.toString();
    }

    private void appendIfPresent(StringBuilder target, URL url, String parameterName) {
        String parameterValue = url.getParameter(parameterName);
        if (!StringUtils.isBlank(parameterValue)) {
            target.append(SERVICE_NAME_SEPARATOR).append(parameterValue);
        }
    }

    private boolean isAdminProtocol(URL url) {
        return "admin".equals(url.getProtocol());
    }

    private void scheduleServiceNamesLookup(URL url, NacosAggregateListener listener) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Set<String> serviceNames = this.getAllServiceNames();
                this.filterData(serviceNames, serviceName -> {
                    boolean accepted = false;
                    for (String category : ALL_SUPPORTED_CATEGORIES) {
                        String prefix = category + SERVICE_NAME_SEPARATOR;
                        if (serviceName == null || !serviceName.startsWith(prefix)) continue;
                        accepted = true;
                        break;
                    }
                    return accepted;
                });
                this.doSubscribe(url, listener, serviceNames);
            }, LOOKUP_INTERVAL, LOOKUP_INTERVAL, TimeUnit.SECONDS);
        }
    }

    private Set<String> getServiceNamesForOps(URL url) {
        Set<String> serviceNames = this.getAllServiceNames();
        this.filterServiceNames(serviceNames, url);
        return serviceNames;
    }

    private Set<String> getAllServiceNames() {
        try {
            LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
            int pageIndex = 1;
            ListView<String> listView = this.namingService.getServicesOfServer(pageIndex, PAGINATION_SIZE, this.getUrl().getGroup("DEFAULT_GROUP"));
            List firstPageData = listView.getData();
            serviceNames.addAll(firstPageData);
            int count = listView.getCount();
            int pageNumbers = count / PAGINATION_SIZE;
            int remainder = count % PAGINATION_SIZE;
            if (remainder > 0) {
                ++pageNumbers;
            }
            while (pageIndex < pageNumbers) {
                listView = this.namingService.getServicesOfServer(++pageIndex, PAGINATION_SIZE, this.getUrl().getGroup("DEFAULT_GROUP"));
                serviceNames.addAll(listView.getData());
            }
            return serviceNames;
        }
        catch (SkipFailbackWrapperException exception) {
            throw exception;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to get all serviceName from nacos, url: " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    private void filterServiceNames(Set<String> serviceNames, URL url) {
        List<String> categories = this.getCategories(url);
        String targetServiceInterface = url.getServiceInterface();
        String targetVersion = url.getVersion("");
        String targetGroup = url.getGroup("");
        this.filterData(serviceNames, serviceName -> {
            String[] segments = serviceName.split(SERVICE_NAME_SEPARATOR, -1);
            int length = segments.length;
            if (length != 4) {
                return false;
            }
            String category = segments[0];
            if (!categories.contains(category)) {
                return false;
            }
            String serviceInterface = segments[1];
            if (!WILDCARD.equals(targetServiceInterface) && !StringUtils.isEquals(targetServiceInterface, serviceInterface)) {
                return false;
            }
            String version = segments[2];
            if (!WILDCARD.equals(targetVersion) && !StringUtils.isEquals(targetVersion, version)) {
                return false;
            }
            String group = segments[3];
            return group == null || WILDCARD.equals(targetGroup) || StringUtils.isEquals(targetGroup, group);
        });
    }

    private <T> void filterData(Collection<T> collection, NacosDataFilter<T> filter) {
        collection.removeIf(data -> !filter.accept(data));
    }

    @Deprecated
    private List<String> doGetServiceNames(URL url) {
        List<String> categories = this.getCategories(url);
        ArrayList<String> serviceNames = new ArrayList<String>(categories.size());
        for (String category : categories) {
            String serviceName = this.getServiceName(url, category);
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.namingService.shutdown();
        }
        catch (NacosException e) {
            logger.warn("1-37", "", "", "Unable to shutdown nacos naming service", e);
        }
        this.nacosListeners.clear();
    }

    private List<URL> toUrlWithEmpty(URL consumerURL, Collection<Instance> instances) {
        List<URL> urls = this.buildURLs(consumerURL = this.removeParamsFromConsumer(consumerURL), instances);
        if (urls.size() == 0 && !this.getUrl().getParameter("enable-empty-protection", false)) {
            logger.warn("1-37", "", "", "Received empty url address list and empty protection is disabled, will clear current available addresses");
            ServiceConfigURL empty = URLBuilder.from(consumerURL).setProtocol("empty").addParameter("category", "providers").build();
            urls.add(empty);
        }
        return urls;
    }

    private List<URL> buildURLs(URL consumerURL, Collection<Instance> instances) {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (instances != null && !instances.isEmpty()) {
            for (Instance instance : instances) {
                URL url = this.buildURL(consumerURL, instance);
                if (!UrlUtils.isMatch(consumerURL, url)) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private void subscribeEventListener(String serviceName, URL url, NacosAggregateListener listener) throws NacosException {
        Map listeners = this.nacosListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
        Map eventListeners = listeners.computeIfAbsent(listener, k -> new ConcurrentHashMap());
        EventListener eventListener = eventListeners.computeIfAbsent(serviceName, k -> new RegistryChildListenerImpl(serviceName, url, listener));
        this.namingService.subscribe(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"), eventListener);
    }

    private void unsubscribeEventListener(String serviceName, URL url, NacosAggregateListener listener) throws NacosException {
        Map<NacosAggregateListener, Map<String, EventListener>> listenerToServiceEvent = this.nacosListeners.get(url);
        if (listenerToServiceEvent == null) {
            return;
        }
        Map<String, EventListener> serviceToEventMap = listenerToServiceEvent.get(listener);
        if (serviceToEventMap == null) {
            return;
        }
        EventListener eventListener = serviceToEventMap.remove(serviceName);
        if (eventListener == null) {
            return;
        }
        this.namingService.unsubscribe(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"), eventListener);
        if (serviceToEventMap.isEmpty()) {
            listenerToServiceEvent.remove(listener);
        }
        if (listenerToServiceEvent.isEmpty()) {
            this.nacosListeners.remove(url);
        }
    }

    private void notifySubscriber(URL url, String serviceName, NacosAggregateListener listener, Collection<Instance> instances) {
        LinkedList<Instance> enabledInstances = new LinkedList<Instance>(instances);
        if (enabledInstances.size() > 0) {
            this.filterEnabledInstances(enabledInstances);
        }
        List<URL> aggregatedUrls = this.toUrlWithEmpty(url, listener.saveAndAggregateAllInstances(serviceName, enabledInstances));
        this.notify(url, listener.getNotifyListener(), aggregatedUrls);
    }

    private List<String> getCategories(URL url) {
        return WILDCARD.equals(url.getServiceInterface()) ? ALL_SUPPORTED_CATEGORIES : Arrays.asList("providers");
    }

    private URL buildURL(URL consumerURL, Instance instance) {
        Map metadata = instance.getMetadata();
        String protocol = (String)metadata.get("protocol");
        String path = (String)metadata.get("path");
        ServiceConfigURL url = new ServiceConfigURL(protocol, instance.getIp(), instance.getPort(), path, instance.getMetadata());
        return new DubboServiceAddressURL(url.getUrlAddress(), url.getUrlParam(), consumerURL, null);
    }

    private Instance createInstance(URL url) {
        String category = url.getCategory("providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        newURL = newURL.addParameter("path", url.getPath());
        String ip = url.getHost();
        int port = url.getPort();
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setMetadata(new HashMap<String, String>(newURL.getParameters()));
        return instance;
    }

    private NacosServiceName createServiceName(URL url) {
        return NacosServiceName.valueOf(url);
    }

    private String getServiceName(URL url, boolean needCompatible) {
        if (needCompatible) {
            return this.getCompatibleServiceName(url, url.getCategory("providers"));
        }
        return this.getServiceName(url, url.getCategory("providers"));
    }

    private String getServiceName(URL url, String category) {
        return category + SERVICE_NAME_SEPARATOR + url.getColonSeparatedKey();
    }

    private String getCompatibleServiceName(URL url, String category) {
        return category + SERVICE_NAME_SEPARATOR + url.getCompatibleColonSeparatedKey();
    }

    private void filterEnabledInstances(Collection<Instance> instances) {
        this.filterData(instances, Instance::isEnabled);
    }

    private static interface NacosDataFilter<T> {
        public boolean accept(T var1);
    }

    private class RegistryChildListenerImpl
    implements EventListener {
        private final RegistryNotifier notifier;
        private final String serviceName;
        private final URL consumerUrl;
        private final NacosAggregateListener listener;

        public RegistryChildListenerImpl(final String serviceName, final URL consumerUrl, final NacosAggregateListener listener) {
            this.serviceName = serviceName;
            this.consumerUrl = consumerUrl;
            this.listener = listener;
            this.notifier = new RegistryNotifier(NacosRegistry.this.getUrl(), NacosRegistry.this.getDelay()){

                @Override
                protected void doNotify(Object rawAddresses) {
                    List instances = (List)rawAddresses;
                    NacosRegistry.this.notifySubscriber(consumerUrl, serviceName, listener, instances);
                }
            };
        }

        public void onEvent(Event event) {
            if (event instanceof NamingEvent) {
                NamingEvent e = (NamingEvent)event;
                this.notifier.notify(e.getInstances());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryChildListenerImpl that = (RegistryChildListenerImpl)o;
            return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.consumerUrl, that.consumerUrl) && Objects.equals(this.listener, that.listener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.consumerUrl, this.listener);
        }
    }
}

