/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.textui;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.textui.TComponent;

public class TTable
implements TComponent {
    private final ColumnDefine[] columnDefineArray;
    private final Border border = new Border();
    private int padding;

    public TTable(ColumnDefine[] columnDefineArray) {
        this.columnDefineArray = null == columnDefineArray ? new ColumnDefine[]{} : columnDefineArray;
    }

    public TTable(int columnNum) {
        this.columnDefineArray = new ColumnDefine[columnNum];
        for (int index = 0; index < this.columnDefineArray.length; ++index) {
            this.columnDefineArray[index] = new ColumnDefine();
        }
    }

    @Override
    public String rendering() {
        StringBuilder tableSB = new StringBuilder();
        int[] widthCacheArray = new int[this.getColumnCount()];
        for (int index = 0; index < widthCacheArray.length; ++index) {
            widthCacheArray[index] = Math.abs(this.columnDefineArray[index].getWidth());
        }
        int rowCount = this.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            boolean isLastRow;
            boolean isFirstRow = rowIndex == 0;
            boolean bl = isLastRow = rowIndex == rowCount - 1;
            if (isFirstRow && this.border.has(1)) {
                tableSB.append(this.drawSeparationLine(widthCacheArray)).append(System.lineSeparator());
            }
            if (!isFirstRow && this.border.has(16)) {
                tableSB.append(this.drawSeparationLine(widthCacheArray)).append(System.lineSeparator());
            }
            tableSB.append(this.drawRow(widthCacheArray, rowIndex));
            if (!isLastRow || !this.border.has(4)) continue;
            tableSB.append(this.drawSeparationLine(widthCacheArray)).append(System.lineSeparator());
        }
        return tableSB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String drawRow(int[] widthCacheArray, int rowIndex) {
        StringBuilder rowSB = new StringBuilder();
        Scanner[] scannerArray = new Scanner[this.getColumnCount()];
        try {
            boolean hasNextLine;
            do {
                hasNextLine = false;
                StringBuilder segmentSB = new StringBuilder();
                for (int colIndex = 0; colIndex < this.getColumnCount(); ++colIndex) {
                    String data;
                    Scanner scanner;
                    boolean isLastColOfRow;
                    int width = widthCacheArray[colIndex];
                    boolean isFirstColOfRow = colIndex == 0;
                    boolean bl = isLastColOfRow = colIndex == widthCacheArray.length - 1;
                    String borderChar = isFirstColOfRow && this.border.has(8) ? "|" : (!isFirstColOfRow && this.border.has(32) ? "|" : "");
                    if (null == scannerArray[colIndex]) {
                        scannerArray[colIndex] = new Scanner(new StringReader(TTable.wrap(this.getData(rowIndex, this.columnDefineArray[colIndex]), width)));
                    }
                    if ((scanner = scannerArray[colIndex]).hasNextLine()) {
                        data = scanner.nextLine();
                        hasNextLine = true;
                    } else {
                        data = "";
                    }
                    if (width > 0) {
                        ColumnDefine columnDefine = this.columnDefineArray[colIndex];
                        String dataFormat = this.getDataFormat(columnDefine, width, data);
                        String paddingChar = StringUtils.repeat(" ", this.padding);
                        segmentSB.append(String.format(borderChar + paddingChar + dataFormat + paddingChar, data));
                    }
                    if (!isLastColOfRow) continue;
                    if (this.border.has(2)) {
                        segmentSB.append('|');
                    }
                    segmentSB.append(System.lineSeparator());
                }
                if (!hasNextLine) continue;
                rowSB.append((CharSequence)segmentSB);
            } while (hasNextLine);
            String string = rowSB.toString();
            return string;
        }
        finally {
            for (Scanner scanner : scannerArray) {
                if (null == scanner) continue;
                scanner.close();
            }
        }
    }

    private String getData(int rowIndex, ColumnDefine columnDefine) {
        return columnDefine.getRowCount() <= rowIndex ? "" : (String)columnDefine.rows.get(rowIndex);
    }

    private String getDataFormat(ColumnDefine columnDefine, int width, String data) {
        switch (columnDefine.align.ordinal()) {
            case 2: {
                int length = StringUtils.length(data);
                int diff = width - length;
                int left = diff / 2;
                return StringUtils.repeat(" ", diff - left) + "%s" + StringUtils.repeat(" ", left);
            }
            case 1: {
                return "%" + width + "s";
            }
        }
        return "%-" + width + "s";
    }

    private int getRowCount() {
        int rowCount = 0;
        for (ColumnDefine columnDefine : this.columnDefineArray) {
            rowCount = Math.max(rowCount, columnDefine.getRowCount());
        }
        return rowCount;
    }

    private int indexLastCol(int[] widthCacheArray) {
        for (int colIndex = widthCacheArray.length - 1; colIndex >= 0; --colIndex) {
            int width = widthCacheArray[colIndex];
            if (width <= 0) continue;
            return colIndex;
        }
        return 0;
    }

    private String drawSeparationLine(int[] widthCacheArray) {
        StringBuilder separationLineSB = new StringBuilder();
        int lastCol = this.indexLastCol(widthCacheArray);
        int colCount = widthCacheArray.length;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            boolean isLastCol;
            int width = widthCacheArray[colIndex];
            if (width <= 0) continue;
            boolean isFirstCol = colIndex == 0;
            boolean bl = isLastCol = colIndex == lastCol;
            if (isFirstCol && this.border.has(8)) {
                separationLineSB.append('+');
            }
            if (!isFirstCol && this.border.has(32)) {
                separationLineSB.append('+');
            }
            separationLineSB.append(StringUtils.repeat("-", width + 2 * this.padding));
            if (!isLastCol || !this.border.has(2)) continue;
            separationLineSB.append('+');
        }
        return separationLineSB.toString();
    }

    public TTable addRow(Object ... columnDataArray) {
        if (null != columnDataArray) {
            for (int index = 0; index < this.columnDefineArray.length; ++index) {
                ColumnDefine columnDefine = this.columnDefineArray[index];
                if (index < columnDataArray.length && null != columnDataArray[index]) {
                    columnDefine.rows.add(TTable.replaceTab(columnDataArray[index].toString()));
                    continue;
                }
                columnDefine.rows.add("");
            }
        }
        return this;
    }

    public TTable padding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getColumnCount() {
        return this.columnDefineArray.length;
    }

    private static String replaceTab(String string) {
        return StringUtils.replace(string, "\t", "    ");
    }

    private static int width(String string) {
        int maxWidth = 0;
        try (Scanner scanner = new Scanner(new StringReader(string));){
            while (scanner.hasNextLine()) {
                maxWidth = Math.max(StringUtils.length(scanner.nextLine()), maxWidth);
            }
        }
        return maxWidth;
    }

    public Border getBorder() {
        return this.border;
    }

    public static String wrap(String string, int width) {
        StringBuilder sb = new StringBuilder();
        char[] buffer = string.toCharArray();
        int count = 0;
        for (char c : buffer) {
            if (count == width) {
                count = 0;
                sb.append('\n');
                if (c == '\n') continue;
            }
            count = c == '\n' ? 0 : ++count;
            sb.append(c);
        }
        return sb.toString();
    }

    public class Border {
        private int borders = 63;
        public static final int BORDER_OUTER_TOP = 1;
        public static final int BORDER_OUTER_RIGHT = 2;
        public static final int BORDER_OUTER_BOTTOM = 4;
        public static final int BORDER_OUTER_LEFT = 8;
        public static final int BORDER_INNER_H = 16;
        public static final int BORDER_INNER_V = 32;
        public static final int BORDER_OUTER = 15;
        public static final int BORDER_INNER = 48;
        public static final int BORDER_NON = 0;

        public boolean has(int ... borderArray) {
            if (null == borderArray) {
                return false;
            }
            for (int b : borderArray) {
                if ((this.borders & b) != b) continue;
                return true;
            }
            return false;
        }

        public int get() {
            return this.borders;
        }

        public Border set(int border) {
            this.borders = border;
            return this;
        }

        public Border add(int border) {
            return this.set(this.get() | border);
        }

        public Border remove(int border) {
            return this.set(this.get() ^ border);
        }
    }

    public static class ColumnDefine {
        private final int width;
        private final boolean isAutoResize;
        private final Align align;
        private final List<String> rows = new ArrayList<String>();

        public ColumnDefine(int width, boolean isAutoResize, Align align) {
            this.width = width;
            this.isAutoResize = isAutoResize;
            this.align = align;
        }

        public ColumnDefine(Align align) {
            this(0, true, align);
        }

        public ColumnDefine(int width) {
            this(width, false, Align.LEFT);
        }

        public ColumnDefine(int width, Align align) {
            this(width, false, align);
        }

        public ColumnDefine() {
            this(Align.LEFT);
        }

        public int getWidth() {
            if (!this.isAutoResize) {
                return this.width;
            }
            int maxWidth = 0;
            for (String data : this.rows) {
                maxWidth = Math.max(TTable.width(data), maxWidth);
            }
            return maxWidth;
        }

        public int getRowCount() {
            return this.rows.size();
        }
    }

    public static enum Align {
        LEFT,
        RIGHT,
        MIDDLE;

    }
}

