/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.api.QosConfiguration;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.DefaultCommandExecutor;
import org.apache.dubbo.qos.command.decoder.TelnetCommandDecoder;
import org.apache.dubbo.qos.command.exception.NoSuchCommandException;
import org.apache.dubbo.qos.command.exception.PermissionDenyException;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class TelnetProcessHandler
extends SimpleChannelInboundHandler<String> {
    private static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(TelnetProcessHandler.class);
    private final CommandExecutor commandExecutor;
    private final QosConfiguration qosConfiguration;

    public TelnetProcessHandler(FrameworkModel frameworkModel, QosConfiguration qosConfiguration) {
        this.commandExecutor = new DefaultCommandExecutor(frameworkModel);
        this.qosConfiguration = qosConfiguration;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        if (StringUtils.isBlank(msg)) {
            ctx.writeAndFlush("dubbo>");
        } else {
            CommandContext commandContext = TelnetCommandDecoder.decode(msg);
            commandContext.setQosConfiguration(this.qosConfiguration);
            commandContext.setRemote(ctx.channel());
            try {
                String result = this.commandExecutor.execute(commandContext);
                if (StringUtils.isEquals("close!", result)) {
                    ctx.writeAndFlush(this.getByeLabel()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    ctx.writeAndFlush(result + "\r\n" + "dubbo>");
                }
            }
            catch (NoSuchCommandException ex) {
                ctx.writeAndFlush(msg + " :no such command");
                ctx.writeAndFlush("\r\ndubbo>");
                log.error("7-5", "", "", "can not found command " + commandContext, ex);
            }
            catch (PermissionDenyException ex) {
                ctx.writeAndFlush(msg + " :permission deny");
                ctx.writeAndFlush("\r\ndubbo>");
                log.error("7-7", "", "", "permission deny to access command " + commandContext, ex);
            }
            catch (Exception ex) {
                ctx.writeAndFlush(msg + " :fail to execute commandContext by " + ex.getMessage());
                ctx.writeAndFlush("\r\ndubbo>");
                log.error("7-6", "", "", "execute commandContext got exception " + commandContext, ex);
            }
        }
    }

    private String getByeLabel() {
        return "BYE!\n";
    }
}

