/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.LineBasedFrameDecoder;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.string.StringDecoder;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.string.StringEncoder;
import org.apache.dubbo.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.dubbo.netty.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.apache.dubbo.netty.shaded.io.netty.util.CharsetUtil;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import org.apache.dubbo.qos.api.QosConfiguration;
import org.apache.dubbo.qos.server.handler.CtrlCHandler;
import org.apache.dubbo.qos.server.handler.ForeignHostPermitHandler;
import org.apache.dubbo.qos.server.handler.HttpProcessHandler;
import org.apache.dubbo.qos.server.handler.TelnetIdleEventHandler;
import org.apache.dubbo.qos.server.handler.TelnetProcessHandler;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class QosProcessHandler
extends ByteToMessageDecoder {
    private ScheduledFuture<?> welcomeFuture;
    private final FrameworkModel frameworkModel;
    public static final String PROMPT = "dubbo>";
    private final QosConfiguration qosConfiguration;

    public QosProcessHandler(FrameworkModel frameworkModel, QosConfiguration qosConfiguration) {
        this.frameworkModel = frameworkModel;
        this.qosConfiguration = qosConfiguration;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.welcomeFuture = ctx.executor().schedule(() -> {
            String welcome = this.qosConfiguration.getWelcome();
            if (welcome != null) {
                ctx.write(Unpooled.wrappedBuffer(welcome.getBytes()));
                ctx.writeAndFlush(Unpooled.wrappedBuffer(PROMPT.getBytes()));
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 1) {
            return;
        }
        byte magic = in.getByte(in.readerIndex());
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ForeignHostPermitHandler(this.qosConfiguration));
        if (QosProcessHandler.isHttp(magic)) {
            if (this.welcomeFuture != null && this.welcomeFuture.isCancellable()) {
                this.welcomeFuture.cancel(false);
            }
            p.addLast(new HttpServerCodec());
            p.addLast(new HttpObjectAggregator(0x100000));
            p.addLast(new HttpProcessHandler(this.frameworkModel, this.qosConfiguration));
            p.remove(this);
        } else {
            p.addLast(new CtrlCHandler());
            p.addLast(new LineBasedFrameDecoder(2048));
            p.addLast(new StringDecoder(CharsetUtil.UTF_8));
            p.addLast(new StringEncoder(CharsetUtil.UTF_8));
            p.addLast(new IdleStateHandler(0, 0, 300));
            p.addLast(new TelnetIdleEventHandler());
            p.addLast(new TelnetProcessHandler(this.frameworkModel, this.qosConfiguration));
            p.remove(this);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ExecutorUtil.cancelScheduledFuture(this.welcomeFuture);
            ctx.close();
        }
    }

    private static boolean isHttp(int magic) {
        return magic == 71 || magic == 80;
    }
}

