/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.api.QosConfiguration;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.DefaultCommandExecutor;
import org.apache.dubbo.qos.command.decoder.HttpCommandDecoder;
import org.apache.dubbo.qos.command.exception.NoSuchCommandException;
import org.apache.dubbo.qos.command.exception.PermissionDenyException;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class HttpProcessHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(HttpProcessHandler.class);
    private final CommandExecutor commandExecutor;
    private final QosConfiguration qosConfiguration;

    public HttpProcessHandler(FrameworkModel frameworkModel, QosConfiguration qosConfiguration) {
        this.commandExecutor = new DefaultCommandExecutor(frameworkModel);
        this.qosConfiguration = qosConfiguration;
    }

    private static FullHttpResponse http(int httpCode, String result) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(httpCode), Unpooled.wrappedBuffer(result.getBytes()));
        HttpHeaders httpHeaders = response.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }

    private static FullHttpResponse http(int httpCode) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(httpCode));
        HttpHeaders httpHeaders = response.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
        CommandContext commandContext = HttpCommandDecoder.decode(msg);
        if (commandContext == null) {
            log.warn("7-6", "", "", "can not found commandContext, url: " + msg.uri());
            FullHttpResponse response = HttpProcessHandler.http(404);
            ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            commandContext.setRemote(ctx.channel());
            commandContext.setQosConfiguration(this.qosConfiguration);
            try {
                String result = this.commandExecutor.execute(commandContext);
                int httpCode = commandContext.getHttpCode();
                FullHttpResponse response = HttpProcessHandler.http(httpCode, result);
                ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            catch (NoSuchCommandException ex) {
                log.error("7-5", "", "", "can not find command: " + commandContext, ex);
                FullHttpResponse response = HttpProcessHandler.http(404);
                ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            catch (PermissionDenyException ex) {
                log.error("7-7", "", "", "permission deny to access command: " + commandContext, ex);
                FullHttpResponse response = HttpProcessHandler.http(403);
                ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            catch (Exception qosEx) {
                log.error("7-6", "", "", "execute commandContext: " + commandContext + " got exception", qosEx);
                FullHttpResponse response = HttpProcessHandler.http(500, qosEx.getMessage());
                ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

