/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.qos.api.QosConfiguration;

public class ForeignHostPermitHandler
extends ChannelHandlerAdapter {
    private final boolean acceptForeignIp;
    private final String acceptForeignIpWhitelist;
    private final Predicate<String> whitelistPredicate;
    private final QosConfiguration qosConfiguration;

    public ForeignHostPermitHandler(QosConfiguration qosConfiguration) {
        this.qosConfiguration = qosConfiguration;
        this.acceptForeignIp = qosConfiguration.isAcceptForeignIp();
        this.acceptForeignIpWhitelist = qosConfiguration.getAcceptForeignIpWhitelist();
        this.whitelistPredicate = qosConfiguration.getAcceptForeignIpWhitelistPredicate();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.acceptForeignIp) {
            return;
        }
        if (this.qosConfiguration.isAllowAnonymousAccess()) {
            return;
        }
        InetAddress inetAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        if (inetAddress.isLoopbackAddress()) {
            return;
        }
        if (this.checkForeignIpInWhiteList(inetAddress)) {
            return;
        }
        ByteBuf cb = Unpooled.wrappedBuffer("\r\nForeign Ip Not Permitted, Consider Config It In Whitelist.\r\n".getBytes());
        ctx.writeAndFlush(cb).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private boolean checkForeignIpInWhiteList(InetAddress inetAddress) {
        if (StringUtils.isEmpty(this.acceptForeignIpWhitelist)) {
            return false;
        }
        String foreignIp = inetAddress.getHostAddress();
        return this.whitelistPredicate.test(foreignIp);
    }
}

