/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.util.CharsetUtil;
import org.apache.dubbo.netty.shaded.io.netty.util.ReferenceCountUtil;

public class CtrlCHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private byte[] CTRLC_BYTES_SEQUENCE = new byte[]{-1, -12, -1, -3, 6};
    private byte[] RESPONSE_SEQUENCE = new byte[]{-1, -4, 6};

    public CtrlCHandler() {
        super(false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        int readerIndex;
        for (int i = readerIndex = buffer.readerIndex(); i < buffer.writerIndex() && buffer.readableBytes() - i >= this.CTRLC_BYTES_SEQUENCE.length; ++i) {
            boolean match = true;
            for (int j = 0; j < this.CTRLC_BYTES_SEQUENCE.length; ++j) {
                if (this.CTRLC_BYTES_SEQUENCE[j] == buffer.getByte(i + j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            buffer.readerIndex(readerIndex + buffer.readableBytes());
            ctx.writeAndFlush(Unpooled.wrappedBuffer(this.RESPONSE_SEQUENCE));
            ctx.writeAndFlush(Unpooled.wrappedBuffer("\r\ndubbo>".getBytes(CharsetUtil.UTF_8)));
            ReferenceCountUtil.release(buffer);
            return;
        }
        ctx.fireChannelRead(buffer);
    }
}

