/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.netty.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInitializer;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.dubbo.qos.api.PermissionLevel;
import org.apache.dubbo.qos.api.QosConfiguration;
import org.apache.dubbo.qos.server.DubboLogo;
import org.apache.dubbo.qos.server.QosBindException;
import org.apache.dubbo.qos.server.handler.QosProcessHandler;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Server {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Server.class);
    private String host;
    private int port;
    private boolean acceptForeignIp = true;
    private String acceptForeignIpWhitelist = "";
    private String anonymousAccessPermissionLevel = PermissionLevel.NONE.name();
    private String anonymousAllowCommands = "";
    private EventLoopGroup boss;
    private EventLoopGroup worker;
    private FrameworkModel frameworkModel;
    private String welcome;
    private AtomicBoolean started = new AtomicBoolean();

    public Server(FrameworkModel frameworkModel) {
        this.welcome = DubboLogo.DUBBO;
        this.frameworkModel = frameworkModel;
    }

    public void setWelcome(String welcome) {
        this.welcome = welcome;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Throwable {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.boss = new NioEventLoopGroup(1, new DefaultThreadFactory("qos-boss", true));
        this.worker = new NioEventLoopGroup(0, new DefaultThreadFactory("qos-worker", true));
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.boss, this.worker);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, true);
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, true);
        serverBootstrap.childHandler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new QosProcessHandler(Server.this.frameworkModel, QosConfiguration.builder().welcome(Server.this.welcome).acceptForeignIp(Server.this.acceptForeignIp).acceptForeignIpWhitelist(Server.this.acceptForeignIpWhitelist).anonymousAccessPermissionLevel(Server.this.anonymousAccessPermissionLevel).anonymousAllowCommands(Server.this.anonymousAllowCommands).build()));
            }
        });
        try {
            if (StringUtils.isBlank(this.host)) {
                serverBootstrap.bind(this.port).sync();
            } else {
                serverBootstrap.bind(this.host, this.port).sync();
            }
            logger.info("qos-server bind localhost:" + this.port);
        }
        catch (Throwable throwable) {
            throw new QosBindException("qos-server can not bind localhost:" + this.port, throwable);
        }
    }

    public void stop() {
        logger.info("qos-server stopped.");
        if (this.boss != null) {
            this.boss.shutdownGracefully();
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully();
        }
        this.started.set(false);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isAcceptForeignIp() {
        return this.acceptForeignIp;
    }

    public void setAcceptForeignIp(boolean acceptForeignIp) {
        this.acceptForeignIp = acceptForeignIp;
    }

    public void setAcceptForeignIpWhitelist(String acceptForeignIpWhitelist) {
        this.acceptForeignIpWhitelist = acceptForeignIpWhitelist;
    }

    public void setAnonymousAccessPermissionLevel(String anonymousAccessPermissionLevel) {
        this.anonymousAccessPermissionLevel = anonymousAccessPermissionLevel;
    }

    public void setAnonymousAllowCommands(String anonymousAllowCommands) {
        this.anonymousAllowCommands = anonymousAllowCommands;
    }

    public String getWelcome() {
        return this.welcome;
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

